/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.QNameModule;
import org.opendaylight.yangtools.yang.model.api.ActionNodeContainer;
import org.opendaylight.yangtools.yang.model.api.CaseSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ChoiceSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DerivableSchemaNode;
import org.opendaylight.yangtools.yang.model.api.GroupingDefinition;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.ModuleImport;
import org.opendaylight.yangtools.yang.model.api.NotificationDefinition;
import org.opendaylight.yangtools.yang.model.api.NotificationNodeContainer;
import org.opendaylight.yangtools.yang.model.api.OperationDefinition;
import org.opendaylight.yangtools.yang.model.api.RevisionAwareXPath;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.TypedDataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.type.LeafrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.repo.api.RevisionSourceIdentifier;
import org.opendaylight.yangtools.yang.model.repo.api.SourceIdentifier;
import org.opendaylight.yangtools.yang.model.util.RevisionAwareXPathImpl;
import org.opendaylight.yangtools.yang.model.util.SchemaNodeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SchemaContextUtil {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaContextUtil.class);
    private static final Splitter COLON_SPLITTER = Splitter.on((char)':');
    private static final Splitter SLASH_SPLITTER = Splitter.on((char)'/');
    private static final Pattern STRIP_PATTERN = Pattern.compile("\\[[^\\[\\]]*\\]");

    private SchemaContextUtil() {
    }

    public static SchemaNode findDataSchemaNode(SchemaContext context, SchemaPath schemaPath) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"Schema Context reference cannot be NULL");
        Preconditions.checkArgument((schemaPath != null ? 1 : 0) != 0, (Object)"Schema Path reference cannot be NULL");
        Iterable prefixedPath = schemaPath.getPathFromRoot();
        if (prefixedPath == null) {
            LOG.debug("Schema path {} has null path", (Object)schemaPath);
            return null;
        }
        LOG.trace("Looking for path {} in context {}", (Object)schemaPath, (Object)context);
        return SchemaContextUtil.findNodeInSchemaContext(context, prefixedPath);
    }

    public static SchemaNode findDataSchemaNode(SchemaContext context, Module module, RevisionAwareXPath nonCondXPath) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"Schema Context reference cannot be NULL");
        Preconditions.checkArgument((module != null ? 1 : 0) != 0, (Object)"Module reference cannot be NULL");
        Preconditions.checkArgument((nonCondXPath != null ? 1 : 0) != 0, (Object)"Non Conditional Revision Aware XPath cannot be NULL");
        String strXPath = nonCondXPath.toString();
        if (strXPath != null) {
            Preconditions.checkArgument((strXPath.indexOf(91) == -1 ? 1 : 0) != 0, (Object)"Revision Aware XPath may not contain a condition");
            if (nonCondXPath.isAbsolute()) {
                List<QName> path = SchemaContextUtil.xpathToQNamePath(context, module, strXPath);
                Optional pureData = context.findDataTreeChild(path);
                return pureData.isPresent() ? (SchemaNode)pureData.get() : SchemaContextUtil.findNodeInSchemaContext(context, path);
            }
        }
        return null;
    }

    public static SchemaNode findDataSchemaNodeForRelativeXPath(SchemaContext context, Module module, SchemaNode actualSchemaNode, RevisionAwareXPath relativeXPath) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"Schema Context reference cannot be NULL");
        Preconditions.checkArgument((module != null ? 1 : 0) != 0, (Object)"Module reference cannot be NULL");
        Preconditions.checkArgument((actualSchemaNode != null ? 1 : 0) != 0, (Object)"Actual Schema Node reference cannot be NULL");
        Preconditions.checkArgument((relativeXPath != null ? 1 : 0) != 0, (Object)"Non Conditional Revision Aware XPath cannot be NULL");
        Preconditions.checkState((!relativeXPath.isAbsolute() ? 1 : 0) != 0, (Object)"Revision Aware XPath MUST be relative i.e. MUST contains ../, for non relative Revision Aware XPath use findDataSchemaNode method");
        SchemaPath actualNodePath = actualSchemaNode.getPath();
        if (actualNodePath != null) {
            Iterable<QName> qnamePath = SchemaContextUtil.resolveRelativeXPath(context, module, relativeXPath, actualSchemaNode);
            Optional pureData = context.findDataTreeChild(qnamePath);
            return pureData.isPresent() ? (SchemaNode)pureData.get() : SchemaContextUtil.findNodeInSchemaContext(context, qnamePath);
        }
        return null;
    }

    public static Module findParentModule(SchemaContext context, SchemaNode schemaNode) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"Schema Context reference cannot be NULL!");
        Preconditions.checkArgument((schemaNode != null ? 1 : 0) != 0, (Object)"Schema Node cannot be NULL!");
        Preconditions.checkState((schemaNode.getPath() != null ? 1 : 0) != 0, (Object)"Schema Path for Schema Node is not set properly (Schema Path is NULL)");
        QName qname = schemaNode.getPath().getLastComponent();
        Preconditions.checkState((qname != null ? 1 : 0) != 0, (Object)"Schema Path contains invalid state of path parts. The Schema Path MUST contain at least ONE QName  which defines namespace and Local name of path.");
        return context.findModule(qname.getModule()).orElse(null);
    }

    public static SchemaNode findNodeInSchemaContext(SchemaContext context, Iterable<QName> path) {
        QName current = path.iterator().next();
        LOG.trace("Looking up module {} in context {}", (Object)current, path);
        Optional module = context.findModule(current.getModule());
        if (!module.isPresent()) {
            LOG.debug("Module {} not found", (Object)current);
            return null;
        }
        return SchemaContextUtil.findNodeInModule((Module)module.get(), path);
    }

    @Nullable
    @Beta
    public static NotificationDefinition getNotificationSchema(@Nonnull SchemaContext schema, @Nonnull SchemaPath path) {
        Preconditions.checkNotNull((Object)schema, (Object)"Schema context must not be null.");
        Preconditions.checkNotNull((Object)path, (Object)"Schema path must not be null.");
        for (NotificationDefinition potential : schema.getNotifications()) {
            if (!path.equals((Object)potential.getPath())) continue;
            return potential;
        }
        return null;
    }

    @Nullable
    @Beta
    public static ContainerSchemaNode getRpcDataSchema(@Nonnull SchemaContext schema, @Nonnull SchemaPath path) {
        Preconditions.checkNotNull((Object)schema, (Object)"Schema context must not be null.");
        Preconditions.checkNotNull((Object)path, (Object)"Schema path must not be null.");
        Iterator it = path.getPathFromRoot().iterator();
        Preconditions.checkArgument((boolean)it.hasNext(), (Object)"Rpc must have QName.");
        QName rpcName = (QName)it.next();
        Preconditions.checkArgument((boolean)it.hasNext(), (Object)"input or output must be part of path.");
        QName inOrOut = (QName)it.next();
        for (RpcDefinition potential : schema.getOperations()) {
            if (!rpcName.equals((Object)potential.getQName())) continue;
            return SchemaNodeUtils.getRpcDataSchema(potential, inOrOut);
        }
        return null;
    }

    public static Set<SourceIdentifier> getConstituentModuleIdentifiers(SchemaContext context) {
        HashSet<SourceIdentifier> ret = new HashSet<SourceIdentifier>();
        for (Module module : context.getModules()) {
            ret.add(SchemaContextUtil.moduleToIdentifier(module));
            for (Module submodule : module.getSubmodules()) {
                ret.add(SchemaContextUtil.moduleToIdentifier(submodule));
            }
        }
        return ret;
    }

    private static SourceIdentifier moduleToIdentifier(Module module) {
        return RevisionSourceIdentifier.create((String)module.getName(), (Optional)module.getRevision());
    }

    private static SchemaNode findNodeInModule(Module module, Iterable<QName> path) {
        Preconditions.checkArgument((module != null ? 1 : 0) != 0, (Object)"Parent reference cannot be NULL");
        Preconditions.checkArgument((path != null ? 1 : 0) != 0, (Object)"Path reference cannot be NULL");
        if (!path.iterator().hasNext()) {
            LOG.debug("No node matching {} found in node {}", path, (Object)module);
            return null;
        }
        QName current = path.iterator().next();
        LOG.trace("Looking for node {} in module {}", (Object)current, (Object)module);
        DataSchemaNode foundNode = null;
        Iterable<QName> nextPath = SchemaContextUtil.nextLevel(path);
        foundNode = module.getDataChildByName(current);
        if (foundNode != null && nextPath.iterator().hasNext()) {
            foundNode = SchemaContextUtil.findNodeIn((SchemaNode)foundNode, nextPath);
        }
        if (foundNode == null && (foundNode = SchemaContextUtil.getGroupingByName((DataNodeContainer)module, current)) != null && nextPath.iterator().hasNext()) {
            foundNode = SchemaContextUtil.findNodeIn((SchemaNode)foundNode, nextPath);
        }
        if (foundNode == null && (foundNode = SchemaContextUtil.getRpcByName(module, current)) != null && nextPath.iterator().hasNext()) {
            foundNode = SchemaContextUtil.findNodeIn((SchemaNode)foundNode, nextPath);
        }
        if (foundNode == null && (foundNode = SchemaContextUtil.getNotificationByName(module, current)) != null && nextPath.iterator().hasNext()) {
            foundNode = SchemaContextUtil.findNodeIn((SchemaNode)foundNode, nextPath);
        }
        if (foundNode == null) {
            LOG.debug("No node matching {} found in node {}", path, (Object)module);
        }
        return foundNode;
    }

    private static SchemaNode findNodeIn(SchemaNode parent, Iterable<QName> path) {
        Preconditions.checkArgument((parent != null ? 1 : 0) != 0, (Object)"Parent reference cannot be NULL");
        Preconditions.checkArgument((path != null ? 1 : 0) != 0, (Object)"Path reference cannot be NULL");
        if (!path.iterator().hasNext()) {
            LOG.debug("No node matching {} found in node {}", path, (Object)parent);
            return null;
        }
        QName current = path.iterator().next();
        LOG.trace("Looking for node {} in node {}", (Object)current, (Object)parent);
        DataSchemaNode foundNode = null;
        Iterable<QName> nextPath = SchemaContextUtil.nextLevel(path);
        if (parent instanceof DataNodeContainer) {
            DataNodeContainer parentDataNodeContainer = (DataNodeContainer)parent;
            foundNode = parentDataNodeContainer.getDataChildByName(current);
            if (foundNode != null && nextPath.iterator().hasNext()) {
                foundNode = SchemaContextUtil.findNodeIn((SchemaNode)foundNode, nextPath);
            }
            if (foundNode == null && (foundNode = SchemaContextUtil.getGroupingByName(parentDataNodeContainer, current)) != null && nextPath.iterator().hasNext()) {
                foundNode = SchemaContextUtil.findNodeIn((SchemaNode)foundNode, nextPath);
            }
        }
        if (foundNode == null && parent instanceof ActionNodeContainer && (foundNode = (SchemaNode)((ActionNodeContainer)parent).getActions().stream().filter(act -> current.equals((Object)act.getQName())).findFirst().orElse(null)) != null && nextPath.iterator().hasNext()) {
            foundNode = SchemaContextUtil.findNodeIn((SchemaNode)foundNode, nextPath);
        }
        if (foundNode == null && parent instanceof NotificationNodeContainer && (foundNode = (SchemaNode)((NotificationNodeContainer)parent).getNotifications().stream().filter(notif -> current.equals((Object)notif.getQName())).findFirst().orElse(null)) != null && nextPath.iterator().hasNext()) {
            foundNode = SchemaContextUtil.findNodeIn((SchemaNode)foundNode, nextPath);
        }
        if (foundNode == null && parent instanceof OperationDefinition) {
            OperationDefinition parentRpcDefinition = (OperationDefinition)parent;
            if (current.getLocalName().equals("input") && (foundNode = parentRpcDefinition.getInput()) != null && nextPath.iterator().hasNext()) {
                foundNode = SchemaContextUtil.findNodeIn((SchemaNode)foundNode, nextPath);
            }
            if (current.getLocalName().equals("output") && (foundNode = parentRpcDefinition.getOutput()) != null && nextPath.iterator().hasNext()) {
                foundNode = SchemaContextUtil.findNodeIn((SchemaNode)foundNode, nextPath);
            }
            if (foundNode == null && (foundNode = SchemaContextUtil.getGroupingByName(parentRpcDefinition, current)) != null && nextPath.iterator().hasNext()) {
                foundNode = SchemaContextUtil.findNodeIn((SchemaNode)foundNode, nextPath);
            }
        }
        if (foundNode == null && parent instanceof ChoiceSchemaNode) {
            foundNode = ((ChoiceSchemaNode)parent).getCaseNodeByName(current);
            if (foundNode != null && nextPath.iterator().hasNext()) {
                foundNode = SchemaContextUtil.findNodeIn((SchemaNode)foundNode, nextPath);
            }
            if (foundNode == null) {
                for (CaseSchemaNode caseNode : ((ChoiceSchemaNode)parent).getCases().values()) {
                    DataSchemaNode maybeChild = caseNode.getDataChildByName(current);
                    if (maybeChild == null) continue;
                    foundNode = SchemaContextUtil.findNodeIn((SchemaNode)maybeChild, nextPath);
                    break;
                }
            }
        }
        if (foundNode == null) {
            LOG.debug("No node matching {} found in node {}", path, (Object)parent);
        }
        return foundNode;
    }

    private static Iterable<QName> nextLevel(Iterable<QName> path) {
        return Iterables.skip(path, (int)1);
    }

    private static RpcDefinition getRpcByName(Module module, QName name) {
        for (RpcDefinition rpc : module.getRpcs()) {
            if (!rpc.getQName().equals((Object)name)) continue;
            return rpc;
        }
        return null;
    }

    private static NotificationDefinition getNotificationByName(Module module, QName name) {
        for (NotificationDefinition notification : module.getNotifications()) {
            if (!notification.getQName().equals((Object)name)) continue;
            return notification;
        }
        return null;
    }

    private static GroupingDefinition getGroupingByName(DataNodeContainer dataNodeContainer, QName name) {
        for (GroupingDefinition grouping : dataNodeContainer.getGroupings()) {
            if (!grouping.getQName().equals((Object)name)) continue;
            return grouping;
        }
        return null;
    }

    private static GroupingDefinition getGroupingByName(OperationDefinition rpc, QName name) {
        for (GroupingDefinition grouping : rpc.getGroupings()) {
            if (!grouping.getQName().equals((Object)name)) continue;
            return grouping;
        }
        return null;
    }

    private static List<QName> xpathToQNamePath(SchemaContext context, Module parentModule, String xpath) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"Schema Context reference cannot be NULL");
        Preconditions.checkArgument((parentModule != null ? 1 : 0) != 0, (Object)"Parent Module reference cannot be NULL");
        Preconditions.checkArgument((xpath != null ? 1 : 0) != 0, (Object)"XPath string reference cannot be NULL");
        LinkedList<QName> path = new LinkedList<QName>();
        for (String pathComponent : SLASH_SPLITTER.split((CharSequence)xpath)) {
            if (pathComponent.isEmpty()) continue;
            path.add(SchemaContextUtil.stringPathPartToQName(context, parentModule, pathComponent));
        }
        return path;
    }

    private static QName stringPathPartToQName(SchemaContext context, Module parentModule, String prefixedPathPart) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"Schema Context reference cannot be NULL");
        Preconditions.checkArgument((parentModule != null ? 1 : 0) != 0, (Object)"Parent Module reference cannot be NULL");
        Preconditions.checkArgument((prefixedPathPart != null ? 1 : 0) != 0, (Object)"Prefixed Path Part cannot be NULL!");
        if (prefixedPathPart.indexOf(58) != -1) {
            Iterator prefixedName = COLON_SPLITTER.split((CharSequence)prefixedPathPart).iterator();
            String modulePrefix = (String)prefixedName.next();
            Module module = SchemaContextUtil.resolveModuleForPrefix(context, parentModule, modulePrefix);
            Preconditions.checkArgument((module != null ? 1 : 0) != 0, (String)"Failed to resolve xpath: no module found for prefix %s in module %s", (Object)modulePrefix, (Object)parentModule.getName());
            return QName.create((QNameModule)module.getQNameModule(), (String)((String)prefixedName.next()));
        }
        return QName.create((URI)parentModule.getNamespace(), (Optional)parentModule.getRevision(), (String)prefixedPathPart);
    }

    private static Module resolveModuleForPrefix(SchemaContext context, Module module, String prefix) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"Schema Context reference cannot be NULL");
        Preconditions.checkArgument((module != null ? 1 : 0) != 0, (Object)"Module reference cannot be NULL");
        Preconditions.checkArgument((prefix != null ? 1 : 0) != 0, (Object)"Prefix string cannot be NULL");
        if (prefix.equals(module.getPrefix())) {
            return module;
        }
        Set imports = module.getImports();
        for (ModuleImport mi : imports) {
            if (!prefix.equals(mi.getPrefix())) continue;
            return context.findModule(mi.getModuleName(), mi.getRevision()).orElse(null);
        }
        return null;
    }

    private static Iterable<QName> resolveRelativeXPath(SchemaContext context, Module module, RevisionAwareXPath relativeXPath, SchemaNode actualSchemaNode) {
        Preconditions.checkArgument((context != null ? 1 : 0) != 0, (Object)"Schema Context reference cannot be NULL");
        Preconditions.checkArgument((module != null ? 1 : 0) != 0, (Object)"Module reference cannot be NULL");
        Preconditions.checkArgument((relativeXPath != null ? 1 : 0) != 0, (Object)"Non Conditional Revision Aware XPath cannot be NULL");
        Preconditions.checkState((!relativeXPath.isAbsolute() ? 1 : 0) != 0, (Object)"Revision Aware XPath MUST be relative i.e. MUST contains ../, for non relative Revision Aware XPath use findDataSchemaNode method");
        Preconditions.checkState((actualSchemaNode.getPath() != null ? 1 : 0) != 0, (Object)"Schema Path reference for Leafref cannot be NULL");
        Iterable xpaths = SLASH_SPLITTER.split((CharSequence)relativeXPath.toString());
        int colCount = 0;
        Iterator it = xpaths.iterator();
        while (it.hasNext() && ((String)it.next()).contains("..")) {
            ++colCount;
        }
        Iterable schemaNodePath = actualSchemaNode.getPath().getPathFromRoot();
        if (Iterables.size((Iterable)schemaNodePath) - colCount >= 0) {
            return Iterables.concat((Iterable)Iterables.limit((Iterable)schemaNodePath, (int)(Iterables.size((Iterable)schemaNodePath) - colCount)), (Iterable)Iterables.transform((Iterable)Iterables.skip((Iterable)xpaths, (int)colCount), input -> SchemaContextUtil.stringPathPartToQName(context, module, input)));
        }
        return Iterables.concat((Iterable)schemaNodePath, (Iterable)Iterables.transform((Iterable)Iterables.skip((Iterable)xpaths, (int)colCount), input -> SchemaContextUtil.stringPathPartToQName(context, module, input)));
    }

    public static TypeDefinition<?> getBaseTypeForLeafRef(LeafrefTypeDefinition typeDefinition, SchemaContext schemaContext, SchemaNode schema) {
        DataSchemaNode dataSchemaNode;
        RevisionAwareXPath pathStatement = typeDefinition.getPathStatement();
        if ((pathStatement = new RevisionAwareXPathImpl(SchemaContextUtil.stripConditionsFromXPathString(pathStatement), pathStatement.isAbsolute())).isAbsolute()) {
            Optional basePotential;
            SchemaNode baseSchema = schema;
            while (baseSchema instanceof DerivableSchemaNode && (basePotential = ((DerivableSchemaNode)baseSchema).getOriginal()).isPresent()) {
                baseSchema = (SchemaNode)basePotential.get();
            }
            Module parentModule = SchemaContextUtil.findParentModuleOfReferencingType(schemaContext, baseSchema);
            dataSchemaNode = (DataSchemaNode)SchemaContextUtil.findDataSchemaNode(schemaContext, parentModule, pathStatement);
        } else {
            Module parentModule = SchemaContextUtil.findParentModule(schemaContext, schema);
            dataSchemaNode = (DataSchemaNode)SchemaContextUtil.findDataSchemaNodeForRelativeXPath(schemaContext, parentModule, schema, pathStatement);
        }
        if (dataSchemaNode == null) {
            return null;
        }
        TypeDefinition<?> targetTypeDefinition = SchemaContextUtil.typeDefinition(dataSchemaNode);
        if (targetTypeDefinition instanceof LeafrefTypeDefinition) {
            return SchemaContextUtil.getBaseTypeForLeafRef((LeafrefTypeDefinition)targetTypeDefinition, schemaContext, (SchemaNode)dataSchemaNode);
        }
        return targetTypeDefinition;
    }

    public static TypeDefinition<?> getBaseTypeForLeafRef(LeafrefTypeDefinition typeDefinition, SchemaContext schemaContext, QName qname) {
        RevisionAwareXPath pathStatement = typeDefinition.getPathStatement();
        RevisionAwareXPathImpl strippedPathStatement = new RevisionAwareXPathImpl(SchemaContextUtil.stripConditionsFromXPathString(pathStatement), pathStatement.isAbsolute());
        if (!strippedPathStatement.isAbsolute()) {
            return null;
        }
        Optional parentModule = schemaContext.findModule(qname.getModule());
        Preconditions.checkArgument((boolean)parentModule.isPresent(), (String)"Failed to find parent module for %s", (Object)qname);
        DataSchemaNode dataSchemaNode = (DataSchemaNode)SchemaContextUtil.findDataSchemaNode(schemaContext, (Module)parentModule.get(), strippedPathStatement);
        TypeDefinition<?> targetTypeDefinition = SchemaContextUtil.typeDefinition(dataSchemaNode);
        if (targetTypeDefinition instanceof LeafrefTypeDefinition) {
            return SchemaContextUtil.getBaseTypeForLeafRef((LeafrefTypeDefinition)targetTypeDefinition, schemaContext, (SchemaNode)dataSchemaNode);
        }
        return targetTypeDefinition;
    }

    private static Module findParentModuleOfReferencingType(SchemaContext schemaContext, SchemaNode schemaNode) {
        Preconditions.checkArgument((schemaContext != null ? 1 : 0) != 0, (Object)"Schema Context reference cannot be NULL!");
        Preconditions.checkArgument((boolean)(schemaNode instanceof TypedDataSchemaNode), (String)"Unsupported node %s", (Object)schemaNode);
        TypeDefinition nodeType = ((TypedDataSchemaNode)schemaNode).getType();
        if (nodeType.getBaseType() != null) {
            while (nodeType.getBaseType() != null) {
                nodeType = nodeType.getBaseType();
            }
            return schemaContext.findModule(nodeType.getQName().getModule()).orElse(null);
        }
        return SchemaContextUtil.findParentModule(schemaContext, schemaNode);
    }

    @VisibleForTesting
    static String stripConditionsFromXPathString(RevisionAwareXPath pathStatement) {
        return STRIP_PATTERN.matcher(pathStatement.toString()).replaceAll("");
    }

    private static TypeDefinition<?> typeDefinition(LeafSchemaNode node) {
        TypeDefinition baseType = node.getType();
        while (baseType.getBaseType() != null) {
            baseType = baseType.getBaseType();
        }
        return baseType;
    }

    private static TypeDefinition<?> typeDefinition(LeafListSchemaNode node) {
        TypeDefinition baseType = node.getType();
        while (baseType.getBaseType() != null) {
            baseType = baseType.getBaseType();
        }
        return baseType;
    }

    private static TypeDefinition<?> typeDefinition(DataSchemaNode node) {
        if (node instanceof LeafListSchemaNode) {
            return SchemaContextUtil.typeDefinition((LeafListSchemaNode)node);
        }
        if (node instanceof LeafSchemaNode) {
            return SchemaContextUtil.typeDefinition((LeafSchemaNode)node);
        }
        throw new IllegalArgumentException("Unhandled parameter type: " + node);
    }
}

