/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util.type;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.util.type.AbstractRestrictedType;
import org.opendaylight.yangtools.yang.model.util.type.AbstractTypeDefinition;

abstract class AbstractDerivedType<T extends TypeDefinition<T>>
extends AbstractTypeDefinition<T> {
    private final T baseType;
    private final Object defaultValue;
    private final String description;
    private final String reference;
    private final Status status;
    private final String units;

    AbstractDerivedType(T baseType, SchemaPath path, Object defaultValue, String description, String reference, Status status, String units, Collection<UnknownSchemaNode> unknownSchemNodes) {
        super(path, unknownSchemNodes);
        this.baseType = (TypeDefinition)Preconditions.checkNotNull(baseType);
        this.status = (Status)Preconditions.checkNotNull((Object)status);
        this.defaultValue = defaultValue;
        this.description = description;
        this.reference = reference;
        this.units = units;
    }

    public final T getBaseType() {
        return (T)(this.baseType instanceof AbstractRestrictedType ? this.baseType.getBaseType() : this.baseType);
    }

    final T baseType() {
        return this.baseType;
    }

    public final Optional<? extends Object> getDefaultValue() {
        return this.defaultValue != null ? Optional.of(this.defaultValue) : this.baseType.getDefaultValue();
    }

    public final Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    public final Optional<String> getReference() {
        return Optional.ofNullable(this.reference);
    }

    @Nonnull
    public final Status getStatus() {
        return this.status;
    }

    public final Optional<String> getUnits() {
        return this.units != null ? Optional.of(this.units) : this.baseType.getUnits();
    }

    @Override
    public final String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("baseType", this.baseType).add("default", this.defaultValue).add("description", (Object)this.description).add("path", (Object)this.getPath()).add("reference", (Object)this.reference).add("status", (Object)this.status).add("units", (Object)this.units).toString();
    }
}

