/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util.type;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;

abstract class AbstractTypeDefinition<T extends TypeDefinition<T>>
implements Immutable,
TypeDefinition<T> {
    private final List<UnknownSchemaNode> unknownSchemaNodes;
    private final SchemaPath path;

    AbstractTypeDefinition(SchemaPath path, Collection<UnknownSchemaNode> unknownSchemaNodes) {
        this.path = (SchemaPath)Preconditions.checkNotNull((Object)path);
        this.unknownSchemaNodes = ImmutableList.copyOf(unknownSchemaNodes);
    }

    @Nonnull
    public final QName getQName() {
        return this.path.getLastComponent();
    }

    @Nonnull
    public final SchemaPath getPath() {
        return this.path;
    }

    @Nonnull
    public final List<UnknownSchemaNode> getUnknownSchemaNodes() {
        return this.unknownSchemaNodes;
    }

    public abstract String toString();

    public abstract int hashCode();

    public abstract boolean equals(Object var1);
}

