/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util.type;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import org.opendaylight.yangtools.yang.model.api.ConstraintMetaDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.type.DecimalTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.RangeConstraint;
import org.opendaylight.yangtools.yang.model.util.type.AbstractRangeRestrictedBaseType;
import org.opendaylight.yangtools.yang.model.util.type.ResolvedRangeConstraint;

final class BaseDecimalType
extends AbstractRangeRestrictedBaseType<DecimalTypeDefinition, BigDecimal>
implements DecimalTypeDefinition {
    private static final ConstraintMetaDefinition BUILTIN_CONSTRAINT = new ConstraintMetaDefinition(){

        public Optional<String> getReference() {
            return Optional.of("https://tools.ietf.org/html/rfc6020#section-9.3.4");
        }

        public Optional<String> getDescription() {
            return Optional.empty();
        }

        public Optional<String> getErrorMessage() {
            return Optional.empty();
        }

        public Optional<String> getErrorAppTag() {
            return Optional.empty();
        }
    };
    private static final ImmutableList<RangeConstraint<BigDecimal>> IMPLICIT_RANGE_STATEMENTS = ImmutableList.of(BaseDecimalType.createRangeConstraint("-922337203685477580.8", "922337203685477580.7"), BaseDecimalType.createRangeConstraint("-92233720368547758.08", "92233720368547758.07"), BaseDecimalType.createRangeConstraint("-9223372036854775.808", "9223372036854775.807"), BaseDecimalType.createRangeConstraint("-922337203685477.5808", "922337203685477.5807"), BaseDecimalType.createRangeConstraint("-92233720368547.75808", "92233720368547.75807"), BaseDecimalType.createRangeConstraint("-9223372036854.775808", "9223372036854.775807"), BaseDecimalType.createRangeConstraint("-922337203685.4775808", "922337203685.4775807"), BaseDecimalType.createRangeConstraint("-92233720368.54775808", "92233720368.54775807"), BaseDecimalType.createRangeConstraint("-9223372036.854775808", "9223372036.854775807"), BaseDecimalType.createRangeConstraint("-922337203.6854775808", "922337203.6854775807"), BaseDecimalType.createRangeConstraint("-92233720.36854775808", "92233720.36854775807"), BaseDecimalType.createRangeConstraint("-9223372.036854775808", "9223372.036854775807"), (Object[])new RangeConstraint[]{BaseDecimalType.createRangeConstraint("-922337.2036854775808", "922337.2036854775807"), BaseDecimalType.createRangeConstraint("-92233.72036854775808", "92233.72036854775807"), BaseDecimalType.createRangeConstraint("-9223.372036854775808", "9223.372036854775807"), BaseDecimalType.createRangeConstraint("-922.3372036854775808", "922.3372036854775807"), BaseDecimalType.createRangeConstraint("-92.23372036854775808", "92.23372036854775807"), BaseDecimalType.createRangeConstraint("-9.223372036854775808", "9.223372036854775807")});
    private final int fractionDigits;

    private static RangeConstraint<BigDecimal> createRangeConstraint(String min, String max) {
        return new ResolvedRangeConstraint<BigDecimal>(BUILTIN_CONSTRAINT, (RangeSet<BigDecimal>)ImmutableRangeSet.of((Range)Range.closed((Comparable)new BigDecimal(min), (Comparable)new BigDecimal(max))));
    }

    static RangeConstraint<BigDecimal> constraintsForDigits(int fractionDigits) {
        return (RangeConstraint)Verify.verifyNotNull((Object)IMPLICIT_RANGE_STATEMENTS.get(fractionDigits - 1));
    }

    BaseDecimalType(SchemaPath path, List<UnknownSchemaNode> unknownSchemaNodes, int fractionDigits, RangeConstraint<BigDecimal> rangeConstraint) {
        super(path, unknownSchemaNodes, rangeConstraint);
        this.fractionDigits = fractionDigits;
    }

    public int getFractionDigits() {
        return this.fractionDigits;
    }

    @Override
    public int hashCode() {
        return DecimalTypeDefinition.hashCode((DecimalTypeDefinition)this);
    }

    @Override
    public boolean equals(Object obj) {
        return DecimalTypeDefinition.equals((DecimalTypeDefinition)this, (Object)obj);
    }

    @Override
    public String toString() {
        return DecimalTypeDefinition.toString((DecimalTypeDefinition)this);
    }
}

