/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util.type;

import com.google.common.annotations.Beta;
import javax.annotation.Nonnull;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BinaryTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BooleanTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EmptyTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.InstanceIdentifierTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int16TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int32TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int64TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int8TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.StringTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint16TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint32TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint64TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint8TypeDefinition;
import org.opendaylight.yangtools.yang.model.util.type.BaseBinaryType;
import org.opendaylight.yangtools.yang.model.util.type.BaseBooleanType;
import org.opendaylight.yangtools.yang.model.util.type.BaseEmptyType;
import org.opendaylight.yangtools.yang.model.util.type.BaseInstanceIdentifierType;
import org.opendaylight.yangtools.yang.model.util.type.BaseInt16Type;
import org.opendaylight.yangtools.yang.model.util.type.BaseInt32Type;
import org.opendaylight.yangtools.yang.model.util.type.BaseInt64Type;
import org.opendaylight.yangtools.yang.model.util.type.BaseInt8Type;
import org.opendaylight.yangtools.yang.model.util.type.BaseStringType;
import org.opendaylight.yangtools.yang.model.util.type.BaseUint16Type;
import org.opendaylight.yangtools.yang.model.util.type.BaseUint32Type;
import org.opendaylight.yangtools.yang.model.util.type.BaseUint64Type;
import org.opendaylight.yangtools.yang.model.util.type.BaseUint8Type;
import org.opendaylight.yangtools.yang.model.util.type.BitsTypeBuilder;
import org.opendaylight.yangtools.yang.model.util.type.DecimalTypeBuilder;
import org.opendaylight.yangtools.yang.model.util.type.EnumerationTypeBuilder;
import org.opendaylight.yangtools.yang.model.util.type.IdentityrefTypeBuilder;
import org.opendaylight.yangtools.yang.model.util.type.LeafrefTypeBuilder;
import org.opendaylight.yangtools.yang.model.util.type.UnionTypeBuilder;

@Beta
public final class BaseTypes {
    private BaseTypes() {
        throw new UnsupportedOperationException();
    }

    public static BinaryTypeDefinition binaryType() {
        return BaseBinaryType.INSTANCE;
    }

    public static BitsTypeBuilder bitsTypeBuilder(SchemaPath path) {
        return new BitsTypeBuilder(path);
    }

    public static BooleanTypeDefinition booleanType() {
        return BaseBooleanType.INSTANCE;
    }

    public static DecimalTypeBuilder decimalTypeBuilder(SchemaPath path) {
        return new DecimalTypeBuilder(path);
    }

    public static EmptyTypeDefinition emptyType() {
        return BaseEmptyType.INSTANCE;
    }

    public static EnumerationTypeBuilder enumerationTypeBuilder(SchemaPath path) {
        return new EnumerationTypeBuilder(path);
    }

    public static IdentityrefTypeBuilder identityrefTypeBuilder(SchemaPath path) {
        return new IdentityrefTypeBuilder(path);
    }

    public static InstanceIdentifierTypeDefinition instanceIdentifierType() {
        return BaseInstanceIdentifierType.INSTANCE;
    }

    public static Int8TypeDefinition int8Type() {
        return BaseInt8Type.INSTANCE;
    }

    public static boolean isInt8(TypeDefinition<?> type) {
        return BaseInt8Type.INSTANCE.getPath().equals((Object)type.getPath());
    }

    public static Int16TypeDefinition int16Type() {
        return BaseInt16Type.INSTANCE;
    }

    public static boolean isInt16(TypeDefinition<?> type) {
        return BaseInt16Type.INSTANCE.getPath().equals((Object)type.getPath());
    }

    public static Int32TypeDefinition int32Type() {
        return BaseInt32Type.INSTANCE;
    }

    public static boolean isInt32(TypeDefinition<?> type) {
        return BaseInt32Type.INSTANCE.getPath().equals((Object)type.getPath());
    }

    public static Int64TypeDefinition int64Type() {
        return BaseInt64Type.INSTANCE;
    }

    public static boolean isInt64(TypeDefinition<?> type) {
        return BaseInt64Type.INSTANCE.getPath().equals((Object)type.getPath());
    }

    public static LeafrefTypeBuilder leafrefTypeBuilder(SchemaPath path) {
        return new LeafrefTypeBuilder(path);
    }

    public static StringTypeDefinition stringType() {
        return BaseStringType.INSTANCE;
    }

    public static UnionTypeBuilder unionTypeBuilder(SchemaPath path) {
        return new UnionTypeBuilder(path);
    }

    public static Uint8TypeDefinition uint8Type() {
        return BaseUint8Type.INSTANCE;
    }

    public static boolean isUint8(@Nonnull TypeDefinition<?> type) {
        return BaseUint8Type.INSTANCE.getPath().equals((Object)type.getPath());
    }

    public static Uint16TypeDefinition uint16Type() {
        return BaseUint16Type.INSTANCE;
    }

    public static boolean isUint16(@Nonnull TypeDefinition<?> type) {
        return BaseUint16Type.INSTANCE.getPath().equals((Object)type.getPath());
    }

    public static Uint32TypeDefinition uint32Type() {
        return BaseUint32Type.INSTANCE;
    }

    public static boolean isUint32(@Nonnull TypeDefinition<?> type) {
        return BaseUint32Type.INSTANCE.getPath().equals((Object)type.getPath());
    }

    public static Uint64TypeDefinition uint64Type() {
        return BaseUint64Type.INSTANCE;
    }

    public static boolean isUint64(@Nonnull TypeDefinition<?> type) {
        return BaseUint64Type.INSTANCE.getPath().equals((Object)type.getPath());
    }

    public static TypeDefinition<?> baseTypeOf(@Nonnull TypeDefinition<?> type) {
        TypeDefinition ret = type;
        while (ret.getBaseType() != null) {
            ret = ret.getBaseType();
        }
        return ret;
    }
}

