/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util.type;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.concepts.Mutable;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.type.BitImpl;

@Beta
public final class BitBuilder
implements Builder<BitsTypeDefinition.Bit>,
Mutable {
    private final SchemaPath schemaPath;
    private final Long position;
    private List<UnknownSchemaNode> unknownSchemaNodes = ImmutableList.of();
    private Status status = Status.CURRENT;
    private String description;
    private String reference;

    private BitBuilder(SchemaPath schemaPath, Long position) {
        this.schemaPath = (SchemaPath)Preconditions.checkNotNull((Object)schemaPath);
        this.position = (Long)Preconditions.checkNotNull((Object)position);
    }

    public static BitBuilder create(SchemaPath schemaPath, Long position) {
        return new BitBuilder(schemaPath, position);
    }

    public BitBuilder setDescription(String description) {
        this.description = description;
        return this;
    }

    public BitBuilder setReference(String reference) {
        this.reference = reference;
        return this;
    }

    public BitBuilder setStatus(Status status) {
        this.status = (Status)Preconditions.checkNotNull((Object)status);
        return this;
    }

    public BitBuilder setUnknownSchemaNodes(Collection<UnknownSchemaNode> unknownSchemaNodes) {
        this.unknownSchemaNodes = ImmutableList.copyOf(unknownSchemaNodes);
        return this;
    }

    public BitBuilder setUnknownSchemaNodes(UnknownSchemaNode ... unknownSchemaNodes) {
        this.unknownSchemaNodes = ImmutableList.copyOf((Object[])unknownSchemaNodes);
        return this;
    }

    public BitsTypeDefinition.Bit build() {
        return new BitImpl(this.schemaPath, this.position, this.description, this.reference, this.status, this.unknownSchemaNodes);
    }
}

