/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util.type;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.TypedDataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.type.BinaryTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.DecimalTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.InstanceIdentifierTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int16TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int32TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int64TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int8TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LengthRestrictedTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.RangeRestrictedTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.StringTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint16TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint32TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint64TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint8TypeDefinition;

@Deprecated
public final class CompatUtils {
    private CompatUtils() {
        throw new UnsupportedOperationException();
    }

    @Nonnull
    public static TypeDefinition<?> compatType(@Nonnull TypedDataSchemaNode leaf) {
        TypeDefinition leafType = leaf.getType();
        Preconditions.checkNotNull((Object)leafType);
        if (!leaf.getPath().equals((Object)leafType.getPath())) {
            return leafType;
        }
        TypeDefinition baseType = leafType.getBaseType();
        Preconditions.checkArgument((baseType != null ? 1 : 0) != 0, (String)"Leaf %s has type for leaf, but no base type", (Object)leaf);
        if (leaf.getPath().equals((Object)baseType.getPath().getParent())) {
            return baseType;
        }
        if (leafType instanceof BinaryTypeDefinition) {
            return CompatUtils.baseTypeIfNotConstrained((BinaryTypeDefinition)leafType);
        }
        if (leafType instanceof DecimalTypeDefinition) {
            return CompatUtils.baseTypeIfNotConstrained((DecimalTypeDefinition)leafType);
        }
        if (leafType instanceof InstanceIdentifierTypeDefinition) {
            return CompatUtils.baseTypeIfNotConstrained((InstanceIdentifierTypeDefinition)leafType);
        }
        if (leafType instanceof Int8TypeDefinition) {
            return CompatUtils.baseTypeIfNotConstrained((Int8TypeDefinition)leafType);
        }
        if (leafType instanceof Int16TypeDefinition) {
            return CompatUtils.baseTypeIfNotConstrained((Int16TypeDefinition)leafType);
        }
        if (leafType instanceof Int32TypeDefinition) {
            return CompatUtils.baseTypeIfNotConstrained((Int32TypeDefinition)leafType);
        }
        if (leafType instanceof Int64TypeDefinition) {
            return CompatUtils.baseTypeIfNotConstrained((Int64TypeDefinition)leafType);
        }
        if (leafType instanceof StringTypeDefinition) {
            return CompatUtils.baseTypeIfNotConstrained((StringTypeDefinition)leafType);
        }
        if (leafType instanceof Uint8TypeDefinition) {
            return CompatUtils.baseTypeIfNotConstrained((Uint8TypeDefinition)leafType);
        }
        if (leafType instanceof Uint16TypeDefinition) {
            return CompatUtils.baseTypeIfNotConstrained((Uint16TypeDefinition)leafType);
        }
        if (leafType instanceof Uint32TypeDefinition) {
            return CompatUtils.baseTypeIfNotConstrained((Uint32TypeDefinition)leafType);
        }
        if (leafType instanceof Uint64TypeDefinition) {
            return CompatUtils.baseTypeIfNotConstrained((Uint64TypeDefinition)leafType);
        }
        return baseType;
    }

    @Nonnull
    public static TypeDefinition<?> compatLeafType(@Nonnull LeafSchemaNode leaf) {
        return CompatUtils.compatType((TypedDataSchemaNode)leaf);
    }

    private static BinaryTypeDefinition baseTypeIfNotConstrained(BinaryTypeDefinition type) {
        return (BinaryTypeDefinition)CompatUtils.baseTypeIfNotConstrained(type, (LengthRestrictedTypeDefinition)type.getBaseType());
    }

    private static TypeDefinition<?> baseTypeIfNotConstrained(DecimalTypeDefinition type) {
        return CompatUtils.baseTypeIfNotConstrained(type, (RangeRestrictedTypeDefinition)type.getBaseType());
    }

    private static TypeDefinition<?> baseTypeIfNotConstrained(InstanceIdentifierTypeDefinition type) {
        InstanceIdentifierTypeDefinition base = (InstanceIdentifierTypeDefinition)type.getBaseType();
        return type.requireInstance() == base.requireInstance() ? base : type;
    }

    private static TypeDefinition<?> baseTypeIfNotConstrained(StringTypeDefinition type) {
        StringTypeDefinition base = (StringTypeDefinition)type.getBaseType();
        List patterns = type.getPatternConstraints();
        Optional optLengths = type.getLengthConstraint();
        if ((patterns.isEmpty() || patterns.equals(base.getPatternConstraints())) && (!optLengths.isPresent() || optLengths.equals(base.getLengthConstraint()))) {
            return base;
        }
        return type;
    }

    private static <T extends RangeRestrictedTypeDefinition<T, ?>> T baseTypeIfNotConstrained(T type) {
        return (T)CompatUtils.baseTypeIfNotConstrained(type, (RangeRestrictedTypeDefinition)type.getBaseType());
    }

    private static <T extends RangeRestrictedTypeDefinition<T, ?>> T baseTypeIfNotConstrained(T type, T base) {
        Optional optConstraint = type.getRangeConstraint();
        if (!optConstraint.isPresent()) {
            return base;
        }
        return optConstraint.equals(base.getRangeConstraint()) ? base : type;
    }

    private static <T extends LengthRestrictedTypeDefinition<T>> T baseTypeIfNotConstrained(T type, T base) {
        Optional optConstraint = type.getLengthConstraint();
        if (!optConstraint.isPresent()) {
            return base;
        }
        return optConstraint.equals(base.getLengthConstraint()) ? base : type;
    }
}

