/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util.type;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.opendaylight.yangtools.concepts.Immutable;
import org.opendaylight.yangtools.yang.model.api.Status;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;

final class EnumPairImpl
implements EnumTypeDefinition.EnumPair,
Immutable {
    private final List<UnknownSchemaNode> unknownSchemaNodes;
    private final String description;
    private final String reference;
    private final Status status;
    private final String name;
    private final int value;

    EnumPairImpl(String name, int value, String description, String reference, Status status, List<UnknownSchemaNode> unknownSchemaNodes) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.value = value;
        this.description = description;
        this.reference = reference;
        this.status = (Status)Preconditions.checkNotNull((Object)status);
        this.unknownSchemaNodes = (List)Preconditions.checkNotNull(unknownSchemaNodes);
    }

    @Nonnull
    public List<UnknownSchemaNode> getUnknownSchemaNodes() {
        return this.unknownSchemaNodes;
    }

    public Optional<String> getDescription() {
        return Optional.ofNullable(this.description);
    }

    public Optional<String> getReference() {
        return Optional.ofNullable(this.reference);
    }

    @Nonnull
    public Status getStatus() {
        return this.status;
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.unknownSchemaNodes.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + Integer.hashCode(this.value);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EnumTypeDefinition.EnumPair)) {
            return false;
        }
        EnumTypeDefinition.EnumPair other = (EnumTypeDefinition.EnumPair)obj;
        if (!Objects.equals(this.name, other.getName())) {
            return false;
        }
        return this.value == other.getValue() && Objects.equals(this.unknownSchemaNodes, other.getUnknownSchemaNodes());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("value", this.value).toString();
    }
}

