/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util.type;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import javax.annotation.Nonnull;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.type.AbstractRestrictedTypeBuilder;
import org.opendaylight.yangtools.yang.model.util.type.BaseEnumerationType;
import org.opendaylight.yangtools.yang.model.util.type.InvalidEnumDefinitionException;
import org.opendaylight.yangtools.yang.model.util.type.RestrictedEnumerationType;

public final class EnumerationTypeBuilder
extends AbstractRestrictedTypeBuilder<EnumTypeDefinition> {
    private final ImmutableMap.Builder<String, EnumTypeDefinition.EnumPair> builder = ImmutableMap.builder();

    EnumerationTypeBuilder(SchemaPath path) {
        super(null, path);
    }

    EnumerationTypeBuilder(EnumTypeDefinition baseType, SchemaPath path) {
        super(baseType, path);
    }

    public EnumerationTypeBuilder addEnum(@Nonnull EnumTypeDefinition.EnumPair item) {
        if (this.getBaseType() != null) {
            this.validateRestrictedEnum(item);
        }
        this.builder.put((Object)item.getName(), (Object)item);
        this.touch();
        return this;
    }

    private void validateRestrictedEnum(@Nonnull EnumTypeDefinition.EnumPair item) {
        boolean isASubsetOfBaseEnums = false;
        for (EnumTypeDefinition.EnumPair baseTypeEnumPair : ((EnumTypeDefinition)this.getBaseType()).getValues()) {
            if (!item.getName().equals(baseTypeEnumPair.getName())) continue;
            if (item.getValue() != baseTypeEnumPair.getValue()) {
                throw new InvalidEnumDefinitionException(item, "Value of enum '%s' must be the same as the value of corresponding enum in the base enumeration type %s.", item.getName(), ((EnumTypeDefinition)this.getBaseType()).getQName());
            }
            isASubsetOfBaseEnums = true;
            break;
        }
        if (!isASubsetOfBaseEnums) {
            throw new InvalidEnumDefinitionException(item, "Enum '%s' is not a subset of its base enumeration type %s.", item.getName(), ((EnumTypeDefinition)this.getBaseType()).getQName());
        }
    }

    @Override
    public EnumTypeDefinition buildType() {
        ImmutableMap map = this.builder.build();
        HashMap<Integer, EnumTypeDefinition.EnumPair> positionMap = new HashMap<Integer, EnumTypeDefinition.EnumPair>();
        for (EnumTypeDefinition.EnumPair p : map.values()) {
            EnumTypeDefinition.EnumPair conflict = positionMap.put(p.getValue(), p);
            if (conflict == null) continue;
            throw new InvalidEnumDefinitionException(p, "Enum '%s' conflicts on value with enum ", conflict);
        }
        if (this.getBaseType() == null) {
            return new BaseEnumerationType(this.getPath(), this.getUnknownSchemaNodes(), map.values());
        }
        return new RestrictedEnumerationType((EnumTypeDefinition)this.getBaseType(), this.getPath(), this.getUnknownSchemaNodes(), map.values());
    }
}

