/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util.type;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yangtools.yang.model.api.ConstraintMetaDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.stmt.UnresolvedNumber;
import org.opendaylight.yangtools.yang.model.api.stmt.ValueRange;
import org.opendaylight.yangtools.yang.model.api.type.RangeConstraint;
import org.opendaylight.yangtools.yang.model.api.type.RangeRestrictedTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.type.AbstractRestrictedTypeBuilder;
import org.opendaylight.yangtools.yang.model.util.type.InvalidRangeConstraintException;
import org.opendaylight.yangtools.yang.model.util.type.NumberUtil;
import org.opendaylight.yangtools.yang.model.util.type.ResolvedRangeConstraint;

public abstract class RangeRestrictedTypeBuilder<T extends RangeRestrictedTypeDefinition<T, N>, N extends Number>
extends AbstractRestrictedTypeBuilder<T> {
    private ConstraintMetaDefinition constraint;
    private List<ValueRange> ranges;

    RangeRestrictedTypeBuilder(T baseType, SchemaPath path) {
        super(baseType, path);
    }

    public final void setRangeConstraint(@NonNull ConstraintMetaDefinition constraint, @NonNull List<ValueRange> ranges) {
        Preconditions.checkState((this.ranges == null ? 1 : 0) != 0, (String)"Range constraint already defined as %s %s", this.ranges, (Object)this.constraint);
        this.constraint = Objects.requireNonNull(constraint);
        this.ranges = ImmutableList.copyOf(ranges);
        this.touch();
    }

    final RangeConstraint<N> calculateRangeConstraint(RangeConstraint<N> baseRangeConstraint) {
        if (this.ranges == null) {
            return baseRangeConstraint;
        }
        RangeSet baseRangeSet = baseRangeConstraint.getAllowedRanges();
        Verify.verify((!baseRangeSet.isEmpty() ? 1 : 0) != 0, (String)"Base type %s does not define constraints", this.getBaseType());
        Range baseRange = baseRangeSet.span();
        List<ValueRange> resolvedRanges = RangeRestrictedTypeBuilder.ensureResolvedRanges(this.ranges, baseRange);
        RangeSet<T> typedRanges = RangeRestrictedTypeBuilder.ensureTypedRanges(resolvedRanges, ((Number)((Object)baseRange.lowerEndpoint())).getClass());
        if (!baseRangeSet.enclosesAll(typedRanges)) {
            throw new InvalidRangeConstraintException(typedRanges, "Range constraint %s is not a subset of parent constraint %s", typedRanges, baseRangeSet);
        }
        return new ResolvedRangeConstraint<T>(this.constraint, typedRanges);
    }

    private static <C extends Number> List<ValueRange> ensureResolvedRanges(List<ValueRange> unresolved, Range<C> baseRange) {
        for (ValueRange c : unresolved) {
            if (!(c.lowerBound() instanceof UnresolvedNumber) && !(c.upperBound() instanceof UnresolvedNumber)) continue;
            return RangeRestrictedTypeBuilder.resolveRanges(unresolved, baseRange);
        }
        return unresolved;
    }

    private static <T extends Number> List<ValueRange> resolveRanges(List<ValueRange> unresolved, Range<T> baseRange) {
        ArrayList<ValueRange> ret = new ArrayList<ValueRange>(unresolved.size());
        for (ValueRange range : unresolved) {
            Number min = range.lowerBound();
            Number max = range.upperBound();
            if (max instanceof UnresolvedNumber || min instanceof UnresolvedNumber) {
                @NonNull Number rMin = min instanceof UnresolvedNumber ? (Number)((UnresolvedNumber)min).resolveRange(baseRange) : (Number)min;
                @NonNull Number rMax = max instanceof UnresolvedNumber ? (Number)((UnresolvedNumber)max).resolveRange(baseRange) : (Number)max;
                ret.add(ValueRange.of((Number)rMin, (Number)rMax));
                continue;
            }
            ret.add(range);
        }
        return ret;
    }

    private static <T extends Number> RangeSet<T> ensureTypedRanges(List<ValueRange> ranges, Class<? extends Number> clazz) {
        ImmutableRangeSet.Builder builder = ImmutableRangeSet.builder();
        for (ValueRange range : ranges) {
            if (!clazz.isInstance(range.lowerBound()) || !clazz.isInstance(range.upperBound())) {
                return RangeRestrictedTypeBuilder.typedRanges(ranges, clazz);
            }
            builder.add(Range.closed((Comparable)((Object)range.lowerBound()), (Comparable)((Object)range.upperBound())));
        }
        return builder.build();
    }

    private static <T extends Number> RangeSet<T> typedRanges(List<ValueRange> ranges, Class<? extends Number> clazz) {
        Function<Number, ? extends Number> function = NumberUtil.converterTo(clazz);
        Preconditions.checkArgument((function != null ? 1 : 0) != 0, (String)"Unsupported range class %s", clazz);
        ImmutableRangeSet.Builder builder = ImmutableRangeSet.builder();
        for (ValueRange range : ranges) {
            if (!clazz.isInstance(range.lowerBound()) || !clazz.isInstance(range.upperBound())) {
                Number max;
                Number min;
                try {
                    min = function.apply(range.lowerBound());
                    max = function.apply(range.upperBound());
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(String.format("Constraint %s does not fit into range of %s", range, clazz.getSimpleName()), e);
                }
                builder.add(Range.closed((Comparable)((Object)min), (Comparable)((Object)max)));
                continue;
            }
            builder.add(Range.closed((Comparable)((Object)range.lowerBound()), (Comparable)((Object)range.upperBound())));
        }
        return builder.build();
    }
}

