/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util.type;

import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.RangeSet;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.yang.model.api.ConstraintMetaDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LengthConstraint;

final class ResolvedLengthConstraint
implements LengthConstraint {
    private final ConstraintMetaDefinition meta;
    private final RangeSet<Integer> ranges;

    ResolvedLengthConstraint(ConstraintMetaDefinition meta, RangeSet<Integer> ranges) {
        this.meta = Objects.requireNonNull(meta);
        this.ranges = ImmutableRangeSet.copyOf(ranges);
    }

    public Optional<String> getDescription() {
        return this.meta.getDescription();
    }

    public Optional<String> getErrorAppTag() {
        return this.meta.getErrorAppTag();
    }

    public Optional<String> getErrorMessage() {
        return this.meta.getErrorMessage();
    }

    public Optional<String> getReference() {
        return this.meta.getReference();
    }

    public RangeSet<Integer> getAllowedRanges() {
        return this.ranges;
    }
}

