/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util.type;

import com.google.common.annotations.Beta;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.type.BinaryTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BitsTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.BooleanTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.DecimalTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EmptyTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.EnumTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.IdentityrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.InstanceIdentifierTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int16TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int32TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int64TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Int8TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LeafrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.LengthConstraint;
import org.opendaylight.yangtools.yang.model.api.type.RangeConstraint;
import org.opendaylight.yangtools.yang.model.api.type.StringTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint16TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint32TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint64TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.Uint8TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.UnionTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.type.AbstractRestrictedTypeBuilder;
import org.opendaylight.yangtools.yang.model.util.type.BitsTypeBuilder;
import org.opendaylight.yangtools.yang.model.util.type.EnumerationTypeBuilder;
import org.opendaylight.yangtools.yang.model.util.type.InstanceIdentifierTypeBuilder;
import org.opendaylight.yangtools.yang.model.util.type.JavaLengthConstraints;
import org.opendaylight.yangtools.yang.model.util.type.LengthRestrictedTypeBuilder;
import org.opendaylight.yangtools.yang.model.util.type.RangeRestrictedTypeBuilder;
import org.opendaylight.yangtools.yang.model.util.type.RangeRestrictedTypeBuilderWithBase;
import org.opendaylight.yangtools.yang.model.util.type.RequireInstanceRestrictedTypeBuilder;
import org.opendaylight.yangtools.yang.model.util.type.RestrictedBinaryType;
import org.opendaylight.yangtools.yang.model.util.type.RestrictedBooleanType;
import org.opendaylight.yangtools.yang.model.util.type.RestrictedDecimalType;
import org.opendaylight.yangtools.yang.model.util.type.RestrictedEmptyType;
import org.opendaylight.yangtools.yang.model.util.type.RestrictedIdentityrefType;
import org.opendaylight.yangtools.yang.model.util.type.RestrictedInt16Type;
import org.opendaylight.yangtools.yang.model.util.type.RestrictedInt32Type;
import org.opendaylight.yangtools.yang.model.util.type.RestrictedInt64Type;
import org.opendaylight.yangtools.yang.model.util.type.RestrictedInt8Type;
import org.opendaylight.yangtools.yang.model.util.type.RestrictedLeafrefType;
import org.opendaylight.yangtools.yang.model.util.type.RestrictedUint16Type;
import org.opendaylight.yangtools.yang.model.util.type.RestrictedUint32Type;
import org.opendaylight.yangtools.yang.model.util.type.RestrictedUint64Type;
import org.opendaylight.yangtools.yang.model.util.type.RestrictedUint8Type;
import org.opendaylight.yangtools.yang.model.util.type.RestrictedUnionType;
import org.opendaylight.yangtools.yang.model.util.type.StringTypeBuilder;
import org.opendaylight.yangtools.yang.model.util.type.TypeBuilder;

@Beta
public final class RestrictedTypes {
    private RestrictedTypes() {
        throw new UnsupportedOperationException();
    }

    public static LengthRestrictedTypeBuilder<BinaryTypeDefinition> newBinaryBuilder(@Nonnull BinaryTypeDefinition baseType, @Nonnull SchemaPath path) {
        return new LengthRestrictedTypeBuilder<BinaryTypeDefinition>(baseType, path){

            @Override
            BinaryTypeDefinition buildType(@Nullable LengthConstraint constraint) {
                return new RestrictedBinaryType((BinaryTypeDefinition)this.getBaseType(), this.getPath(), (Collection<UnknownSchemaNode>)this.getUnknownSchemaNodes(), constraint);
            }

            @Override
            LengthConstraint typeLengthConstraints() {
                return JavaLengthConstraints.INTEGER_SIZE_CONSTRAINTS;
            }
        };
    }

    public static BitsTypeBuilder newBitsBuilder(BitsTypeDefinition baseType, SchemaPath path) {
        return new BitsTypeBuilder(baseType, path);
    }

    public static TypeBuilder<BooleanTypeDefinition> newBooleanBuilder(@Nonnull BooleanTypeDefinition baseType, @Nonnull SchemaPath path) {
        return new AbstractRestrictedTypeBuilder<BooleanTypeDefinition>(baseType, path){

            @Override
            BooleanTypeDefinition buildType() {
                return new RestrictedBooleanType((BooleanTypeDefinition)this.getBaseType(), this.getPath(), (Collection<UnknownSchemaNode>)this.getUnknownSchemaNodes());
            }
        };
    }

    public static RangeRestrictedTypeBuilder<DecimalTypeDefinition, BigDecimal> newDecima64Builder(DecimalTypeDefinition baseType, SchemaPath path) {
        return new RangeRestrictedTypeBuilderWithBase<DecimalTypeDefinition, BigDecimal>(baseType, path){

            @Override
            DecimalTypeDefinition buildType(RangeConstraint<BigDecimal> rangeConstraint) {
                return new RestrictedDecimalType((DecimalTypeDefinition)this.getBaseType(), this.getPath(), (Collection<UnknownSchemaNode>)this.getUnknownSchemaNodes(), rangeConstraint);
            }
        };
    }

    public static TypeBuilder<EmptyTypeDefinition> newEmptyBuilder(EmptyTypeDefinition baseType, SchemaPath path) {
        return new AbstractRestrictedTypeBuilder<EmptyTypeDefinition>(baseType, path){

            @Override
            EmptyTypeDefinition buildType() {
                return new RestrictedEmptyType((EmptyTypeDefinition)this.getBaseType(), this.getPath(), (Collection<UnknownSchemaNode>)this.getUnknownSchemaNodes());
            }
        };
    }

    public static EnumerationTypeBuilder newEnumerationBuilder(EnumTypeDefinition baseType, SchemaPath path) {
        return new EnumerationTypeBuilder(baseType, path);
    }

    public static TypeBuilder<IdentityrefTypeDefinition> newIdentityrefBuilder(IdentityrefTypeDefinition baseType, SchemaPath path) {
        return new AbstractRestrictedTypeBuilder<IdentityrefTypeDefinition>(baseType, path){

            @Override
            IdentityrefTypeDefinition buildType() {
                return new RestrictedIdentityrefType((IdentityrefTypeDefinition)this.getBaseType(), this.getPath(), (Collection<UnknownSchemaNode>)this.getUnknownSchemaNodes());
            }
        };
    }

    public static InstanceIdentifierTypeBuilder newInstanceIdentifierBuilder(InstanceIdentifierTypeDefinition baseType, SchemaPath path) {
        return new InstanceIdentifierTypeBuilder(baseType, path);
    }

    public static RequireInstanceRestrictedTypeBuilder<LeafrefTypeDefinition> newLeafrefBuilder(LeafrefTypeDefinition baseType, SchemaPath path) {
        return new RequireInstanceRestrictedTypeBuilder<LeafrefTypeDefinition>(baseType, path){

            @Override
            LeafrefTypeDefinition buildType() {
                if (this.getRequireInstance() == ((LeafrefTypeDefinition)this.getBaseType()).requireInstance()) {
                    return (LeafrefTypeDefinition)this.getBaseType();
                }
                return new RestrictedLeafrefType((LeafrefTypeDefinition)this.getBaseType(), this.getPath(), this.getUnknownSchemaNodes(), this.getRequireInstance());
            }
        };
    }

    public static RangeRestrictedTypeBuilder<Int8TypeDefinition, Byte> newInt8Builder(Int8TypeDefinition baseType, SchemaPath path) {
        return new RangeRestrictedTypeBuilderWithBase<Int8TypeDefinition, Byte>(baseType, path){

            @Override
            Int8TypeDefinition buildType(RangeConstraint<Byte> rangeConstraint) {
                return new RestrictedInt8Type((Int8TypeDefinition)this.getBaseType(), this.getPath(), (Collection<UnknownSchemaNode>)this.getUnknownSchemaNodes(), rangeConstraint);
            }
        };
    }

    public static RangeRestrictedTypeBuilder<Int16TypeDefinition, Short> newInt16Builder(Int16TypeDefinition baseType, SchemaPath path) {
        return new RangeRestrictedTypeBuilderWithBase<Int16TypeDefinition, Short>(baseType, path){

            @Override
            Int16TypeDefinition buildType(RangeConstraint<Short> rangeConstraint) {
                return new RestrictedInt16Type((Int16TypeDefinition)this.getBaseType(), this.getPath(), (Collection<UnknownSchemaNode>)this.getUnknownSchemaNodes(), rangeConstraint);
            }
        };
    }

    public static RangeRestrictedTypeBuilder<Int32TypeDefinition, Integer> newInt32Builder(Int32TypeDefinition baseType, SchemaPath path) {
        return new RangeRestrictedTypeBuilderWithBase<Int32TypeDefinition, Integer>(baseType, path){

            @Override
            Int32TypeDefinition buildType(RangeConstraint<Integer> rangeConstraint) {
                return new RestrictedInt32Type((Int32TypeDefinition)this.getBaseType(), this.getPath(), (Collection<UnknownSchemaNode>)this.getUnknownSchemaNodes(), rangeConstraint);
            }
        };
    }

    public static RangeRestrictedTypeBuilder<Int64TypeDefinition, Long> newInt64Builder(Int64TypeDefinition baseType, SchemaPath path) {
        return new RangeRestrictedTypeBuilderWithBase<Int64TypeDefinition, Long>(baseType, path){

            @Override
            Int64TypeDefinition buildType(RangeConstraint<Long> rangeConstraint) {
                return new RestrictedInt64Type((Int64TypeDefinition)this.getBaseType(), this.getPath(), (Collection<UnknownSchemaNode>)this.getUnknownSchemaNodes(), rangeConstraint);
            }
        };
    }

    public static StringTypeBuilder newStringBuilder(StringTypeDefinition baseType, SchemaPath path) {
        return new StringTypeBuilder(baseType, path);
    }

    public static TypeBuilder<UnionTypeDefinition> newUnionBuilder(UnionTypeDefinition baseType, SchemaPath path) {
        return new AbstractRestrictedTypeBuilder<UnionTypeDefinition>(baseType, path){

            @Override
            UnionTypeDefinition buildType() {
                return new RestrictedUnionType((UnionTypeDefinition)this.getBaseType(), this.getPath(), (Collection<UnknownSchemaNode>)this.getUnknownSchemaNodes());
            }
        };
    }

    public static RangeRestrictedTypeBuilder<Uint8TypeDefinition, Short> newUint8Builder(Uint8TypeDefinition baseType, SchemaPath path) {
        return new RangeRestrictedTypeBuilderWithBase<Uint8TypeDefinition, Short>(baseType, path){

            @Override
            Uint8TypeDefinition buildType(RangeConstraint<Short> rangeConstraint) {
                return new RestrictedUint8Type((Uint8TypeDefinition)this.getBaseType(), this.getPath(), (Collection<UnknownSchemaNode>)this.getUnknownSchemaNodes(), rangeConstraint);
            }
        };
    }

    public static RangeRestrictedTypeBuilder<Uint16TypeDefinition, Integer> newUint16Builder(Uint16TypeDefinition baseType, SchemaPath path) {
        return new RangeRestrictedTypeBuilderWithBase<Uint16TypeDefinition, Integer>(baseType, path){

            @Override
            Uint16TypeDefinition buildType(RangeConstraint<Integer> rangeConstraint) {
                return new RestrictedUint16Type((Uint16TypeDefinition)this.getBaseType(), this.getPath(), (Collection<UnknownSchemaNode>)this.getUnknownSchemaNodes(), rangeConstraint);
            }
        };
    }

    public static RangeRestrictedTypeBuilder<Uint32TypeDefinition, Long> newUint32Builder(Uint32TypeDefinition baseType, SchemaPath path) {
        return new RangeRestrictedTypeBuilderWithBase<Uint32TypeDefinition, Long>(baseType, path){

            @Override
            Uint32TypeDefinition buildType(RangeConstraint<Long> rangeConstraint) {
                return new RestrictedUint32Type((Uint32TypeDefinition)this.getBaseType(), this.getPath(), (Collection<UnknownSchemaNode>)this.getUnknownSchemaNodes(), rangeConstraint);
            }
        };
    }

    public static RangeRestrictedTypeBuilder<Uint64TypeDefinition, BigInteger> newUint64Builder(Uint64TypeDefinition baseType, SchemaPath path) {
        return new RangeRestrictedTypeBuilderWithBase<Uint64TypeDefinition, BigInteger>(baseType, path){

            @Override
            Uint64TypeDefinition buildType(RangeConstraint<BigInteger> rangeConstraint) {
                return new RestrictedUint64Type((Uint64TypeDefinition)this.getBaseType(), this.getPath(), (Collection<UnknownSchemaNode>)this.getUnknownSchemaNodes(), rangeConstraint);
            }
        };
    }
}

