/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util.type;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.type.LengthConstraint;
import org.opendaylight.yangtools.yang.model.api.type.PatternConstraint;
import org.opendaylight.yangtools.yang.model.api.type.StringTypeDefinition;
import org.opendaylight.yangtools.yang.model.util.type.JavaLengthConstraints;
import org.opendaylight.yangtools.yang.model.util.type.LengthRestrictedTypeBuilder;
import org.opendaylight.yangtools.yang.model.util.type.RestrictedStringType;

public final class StringTypeBuilder
extends LengthRestrictedTypeBuilder<StringTypeDefinition> {
    private final List<PatternConstraint> patternConstraints = new ArrayList<PatternConstraint>(0);

    StringTypeBuilder(StringTypeDefinition baseType, SchemaPath path) {
        super(baseType, path);
    }

    public StringTypeBuilder addPatternConstraint(PatternConstraint constraint) {
        this.patternConstraints.add((PatternConstraint)Preconditions.checkNotNull((Object)constraint));
        this.touch();
        return this;
    }

    @Override
    LengthConstraint typeLengthConstraints() {
        return JavaLengthConstraints.INTEGER_SIZE_CONSTRAINTS;
    }

    @Override
    StringTypeDefinition buildType(@Nullable LengthConstraint constraint) {
        return new RestrictedStringType((StringTypeDefinition)this.getBaseType(), this.getPath(), this.getUnknownSchemaNodes(), constraint, this.patternConstraints);
    }
}

