/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.model.util.type;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;

public abstract class TypeBuilder<T extends TypeDefinition<T>>
implements Builder<T> {
    private final ImmutableList.Builder<UnknownSchemaNode> unknownSchemaNodes = ImmutableList.builder();
    private final SchemaPath path;
    private final T baseType;

    TypeBuilder(T baseType, SchemaPath path) {
        this.path = (SchemaPath)Preconditions.checkNotNull((Object)path);
        this.baseType = baseType;
    }

    final T getBaseType() {
        return this.baseType;
    }

    final SchemaPath getPath() {
        return this.path;
    }

    final List<UnknownSchemaNode> getUnknownSchemaNodes() {
        return this.unknownSchemaNodes.build();
    }

    public final void addUnknownSchemaNode(UnknownSchemaNode node) {
        this.unknownSchemaNodes.add((Object)node);
    }
}

