/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core;

import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.openehealth.ipf.commons.ihe.xds.core.ExtraMetadataHolder;
import org.openehealth.ipf.commons.ihe.xds.core.stub.ebrs30.lcm.SubmitObjectsRequest;
import org.openehealth.ipf.commons.ihe.xds.core.stub.ebrs30.rim.AssociationType1;
import org.openehealth.ipf.commons.ihe.xds.core.stub.ebrs30.rim.ExtrinsicObjectType;
import org.openehealth.ipf.commons.ihe.xds.core.stub.ebrs30.rim.RegistryPackageType;
import org.openehealth.ipf.commons.ihe.xds.core.stub.ebrs30.rim.SlotType1;
import org.openehealth.ipf.commons.ihe.xds.core.stub.ebrs30.rim.ValueListType;

public class XdsJaxbDataBinding
extends JAXBDataBinding {
    public static final String SUBMISSION_SET_HAS_EXTRA_METADATA = XdsJaxbDataBinding.class.getName() + ".submission.set.has.extra.metadata";
    private static final Map<Object, Map<String, Object>> DATA = Collections.synchronizedMap(new WeakHashMap());

    public static Map<String, Object> getCamelHeaders(Object ebXml) {
        return DATA.computeIfAbsent(ebXml, k -> new HashMap());
    }

    public XdsJaxbDataBinding() {
        this.setUnmarshallerListener(new UnmarshallerListener());
        this.setMarshallerListener(new MarshallerListener());
    }

    public static boolean isExtraMetadataSlotName(String name) {
        return name != null && name.startsWith("urn:") && !name.startsWith("urn:ihe:");
    }

    public static class UnmarshallerListener
    extends Unmarshaller.Listener {
        static final ThreadLocal<Boolean> RESULTS = new ThreadLocal();

        public void afterUnmarshal(Object target, Object parent) {
            if (target instanceof ExtrinsicObjectType) {
                ExtrinsicObjectType ebXml = (ExtrinsicObjectType)target;
                UnmarshallerListener.findExtraMetadata(ebXml.getSlot(), ebXml);
            } else if (target instanceof RegistryPackageType) {
                RegistryPackageType ebXml = (RegistryPackageType)target;
                UnmarshallerListener.findExtraMetadata(ebXml.getSlot(), ebXml);
            } else if (target instanceof AssociationType1) {
                AssociationType1 ebXml = (AssociationType1)target;
                UnmarshallerListener.findExtraMetadata(ebXml.getSlot(), ebXml);
            } else if (target instanceof SubmitObjectsRequest && Boolean.TRUE.equals(RESULTS.get())) {
                XdsJaxbDataBinding.getCamelHeaders(target).put(SUBMISSION_SET_HAS_EXTRA_METADATA, Boolean.TRUE);
                RESULTS.remove();
            }
        }

        private static void findExtraMetadata(List<SlotType1> slots, ExtraMetadataHolder holder) {
            if (slots != null) {
                for (SlotType1 slot : slots) {
                    String name = slot.getName();
                    if (!XdsJaxbDataBinding.isExtraMetadataSlotName(name)) continue;
                    Map<String, List<String>> extraMetadata = holder.getExtraMetadata();
                    if (extraMetadata == null) {
                        extraMetadata = new HashMap<String, List<String>>();
                        holder.setExtraMetadata(extraMetadata);
                    }
                    extraMetadata.put(name, new ArrayList<String>(slot.getValueList().getValue()));
                    RESULTS.set(Boolean.TRUE);
                }
            }
        }
    }

    public static class MarshallerListener
    extends Marshaller.Listener {
        public void beforeMarshal(Object source) {
            if (source instanceof ExtrinsicObjectType) {
                ExtrinsicObjectType ebXml = (ExtrinsicObjectType)source;
                MarshallerListener.injectExtraMetadata(ebXml.getSlot(), ebXml);
            } else if (source instanceof RegistryPackageType) {
                RegistryPackageType ebXml = (RegistryPackageType)source;
                MarshallerListener.injectExtraMetadata(ebXml.getSlot(), ebXml);
            } else if (source instanceof AssociationType1) {
                AssociationType1 ebXml = (AssociationType1)source;
                MarshallerListener.injectExtraMetadata(ebXml.getSlot(), ebXml);
            }
        }

        private static void injectExtraMetadata(List<SlotType1> slots, ExtraMetadataHolder holder) {
            if (holder.getExtraMetadata() != null) {
                slots.removeIf(slot -> XdsJaxbDataBinding.isExtraMetadataSlotName(slot.getName()) && holder.getExtraMetadata().containsKey(slot.getName()));
                holder.getExtraMetadata().entrySet().stream().filter(entry -> XdsJaxbDataBinding.isExtraMetadataSlotName((String)entry.getKey())).forEach(entry -> {
                    SlotType1 slot = new SlotType1();
                    slot.setName((String)entry.getKey());
                    ValueListType valueList = new ValueListType();
                    valueList.getValue().addAll((Collection)entry.getValue());
                    slot.setValueList(valueList);
                    slots.add(slot);
                });
            }
        }
    }
}

