/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.audit;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import lombok.Generated;
import org.openehealth.ipf.commons.audit.codes.EventOutcomeIndicator;
import org.openehealth.ipf.commons.ihe.xds.core.audit.XdsAuditDataset;

public class XdsNonconstructiveDocumentSetRequestAuditDataset
extends XdsAuditDataset {
    private static final long serialVersionUID = -8776033207572005899L;
    private final List<Document> documents = new ArrayList<Document>();

    public XdsNonconstructiveDocumentSetRequestAuditDataset(boolean serverSide) {
        super(serverSide);
    }

    public boolean hasDocuments(Status status) {
        return this.documents.stream().anyMatch(x -> x.status == status);
    }

    public EventOutcomeIndicator getEventOutcomeIndicator(Status status) {
        return status == Status.SUCCESSFUL ? EventOutcomeIndicator.Success : EventOutcomeIndicator.SeriousFailure;
    }

    public EventOutcomeIndicator getEventOutcomeIndicator() {
        throw new UnsupportedOperationException("Call getEventOutcomeIndicator(Status status) instead");
    }

    public void registerProcessedDocument(String documentUniqueId, String repositoryUniqueId, String homeCommunityId) {
        this.documents.stream().filter(x -> x.matches(documentUniqueId, repositoryUniqueId, homeCommunityId)).forEach(x -> x.setStatus(Status.SUCCESSFUL));
    }

    private String[] extract(Status status, Function<Document, String> fieldExtractor) {
        return (String[])this.documents.stream().filter(x -> x.status == status).map(fieldExtractor).toArray(String[]::new);
    }

    public String[] getDocumentIds(Status status) {
        return this.extract(status, x -> x.documentUniqueId);
    }

    public String[] getRepositoryIds(Status status) {
        return this.extract(status, x -> x.repositoryUniqueId);
    }

    public String[] getHomeCommunityIds(Status status) {
        return this.extract(status, x -> x.homeCommunityId);
    }

    public String[] getStudyInstanceIds(Status status) {
        return this.extract(status, x -> x.studyInstanceUID);
    }

    public String[] getSeriesInstanceIds(Status status) {
        return this.extract(status, x -> x.seriesInstanceUID);
    }

    @Generated
    public List<Document> getDocuments() {
        return this.documents;
    }

    public static enum Status {
        SUCCESSFUL,
        NOT_SUCCESSFUL;

    }

    public static class Document
    implements Serializable {
        private static final long serialVersionUID = -2386699338508892135L;
        private final String documentUniqueId;
        private final String repositoryUniqueId;
        private final String homeCommunityId;
        private final String studyInstanceUID;
        private final String seriesInstanceUID;
        private Status status;

        public boolean matches(String documentUniqueId, String repositoryUniqueId, String homeCommunityId) {
            return Objects.equals(this.documentUniqueId, documentUniqueId) && Objects.equals(this.repositoryUniqueId, repositoryUniqueId) && Objects.equals(this.homeCommunityId, homeCommunityId);
        }

        @Generated
        public Document(String documentUniqueId, String repositoryUniqueId, String homeCommunityId, String studyInstanceUID, String seriesInstanceUID, Status status) {
            this.documentUniqueId = documentUniqueId;
            this.repositoryUniqueId = repositoryUniqueId;
            this.homeCommunityId = homeCommunityId;
            this.studyInstanceUID = studyInstanceUID;
            this.seriesInstanceUID = seriesInstanceUID;
            this.status = status;
        }

        @Generated
        public String getDocumentUniqueId() {
            return this.documentUniqueId;
        }

        @Generated
        public String getRepositoryUniqueId() {
            return this.repositoryUniqueId;
        }

        @Generated
        public String getHomeCommunityId() {
            return this.homeCommunityId;
        }

        @Generated
        public String getStudyInstanceUID() {
            return this.studyInstanceUID;
        }

        @Generated
        public String getSeriesInstanceUID() {
            return this.seriesInstanceUID;
        }

        @Generated
        public Status getStatus() {
            return this.status;
        }

        @Generated
        public void setStatus(Status status) {
            this.status = status;
        }
    }
}

