/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.audit.event;

import java.util.Collections;
import java.util.stream.IntStream;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.audit.codes.EventActionCode;
import org.openehealth.ipf.commons.audit.codes.EventOutcomeIndicator;
import org.openehealth.ipf.commons.audit.codes.ParticipantObjectIdTypeCode;
import org.openehealth.ipf.commons.audit.codes.ParticipantObjectTypeCodeRole;
import org.openehealth.ipf.commons.audit.types.EventType;
import org.openehealth.ipf.commons.audit.types.ParticipantObjectIdType;
import org.openehealth.ipf.commons.audit.types.PurposeOfUse;
import org.openehealth.ipf.commons.ihe.core.atna.AuditDataset;
import org.openehealth.ipf.commons.ihe.core.atna.event.PHIExportBuilder;
import org.openehealth.ipf.commons.ihe.xds.core.audit.XdsAuditDataset;
import org.openehealth.ipf.commons.ihe.xds.core.audit.XdsNonconstructiveDocumentSetRequestAuditDataset;
import org.openehealth.ipf.commons.ihe.xds.core.audit.XdsSubmitAuditDataset;

public class XdsPHIExportBuilder
extends PHIExportBuilder<XdsPHIExportBuilder> {
    public XdsPHIExportBuilder(AuditContext auditContext, XdsAuditDataset auditDataset, EventType eventType, PurposeOfUse ... purposesOfUse) {
        this(auditContext, auditDataset, EventActionCode.Read, eventType, purposesOfUse);
    }

    public XdsPHIExportBuilder(AuditContext auditContext, XdsAuditDataset auditDataset, EventActionCode eventActionCode, EventType eventType, PurposeOfUse ... purposesOfUse) {
        super(auditContext, (AuditDataset)auditDataset, eventActionCode, eventType, purposesOfUse);
    }

    public XdsPHIExportBuilder(AuditContext auditContext, AuditDataset auditDataset, EventOutcomeIndicator eventOutcomeIndicator, String eventOutcomeDescription, EventActionCode eventActionCode, EventType eventType, PurposeOfUse ... purposesOfUse) {
        super(auditContext, auditDataset, eventOutcomeIndicator, eventOutcomeDescription, eventActionCode, eventType, purposesOfUse);
    }

    public XdsPHIExportBuilder setSubmissionSet(XdsSubmitAuditDataset auditDataset) {
        return (XdsPHIExportBuilder)this.addExportedEntity(auditDataset.getSubmissionSetUuid(), (ParticipantObjectIdType)ParticipantObjectIdTypeCode.XdsMetadata, ParticipantObjectTypeCodeRole.Job, Collections.emptyList());
    }

    public XdsPHIExportBuilder setSubmissionSetWithHomeCommunityId(XdsSubmitAuditDataset auditDataset, boolean xcaHomeCommunityId) {
        return (XdsPHIExportBuilder)this.addExportedEntity(auditDataset.getSubmissionSetUuid(), (ParticipantObjectIdType)ParticipantObjectIdTypeCode.XdsMetadata, ParticipantObjectTypeCodeRole.Job, this.documentDetails(null, auditDataset.getHomeCommunityId(), null, null, xcaHomeCommunityId));
    }

    public XdsPHIExportBuilder addDocumentIds(XdsNonconstructiveDocumentSetRequestAuditDataset auditDataset, XdsNonconstructiveDocumentSetRequestAuditDataset.Status status, boolean xcaHomeCommunityId) {
        String[] documentIds = auditDataset.getDocumentIds(status);
        String[] homeCommunityIds = auditDataset.getHomeCommunityIds(status);
        String[] repositoryIds = auditDataset.getRepositoryIds(status);
        String[] seriesInstanceIds = auditDataset.getSeriesInstanceIds(status);
        String[] studyInstanceIds = auditDataset.getStudyInstanceIds(status);
        IntStream.range(0, documentIds.length).forEach(i -> this.addExportedEntity(documentIds[i], (ParticipantObjectIdType)ParticipantObjectIdTypeCode.ReportNumber, ParticipantObjectTypeCodeRole.Report, this.documentDetails(repositoryIds[i], homeCommunityIds[i], seriesInstanceIds[i], studyInstanceIds[i], xcaHomeCommunityId)));
        return (XdsPHIExportBuilder)this.self();
    }
}

