/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.metadata;

import ca.uhn.hl7v2.model.Primitive;
import ca.uhn.hl7v2.model.v25.datatype.CE;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Hl7v2Based;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.LocalizedString;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.jaxbadapters.LocalizedStringAdapter;

@XmlAccessorType
@XmlType(name="Code", propOrder={"code", "schemeName", "displayName"})
public class Code
extends Hl7v2Based<CE> {
    private static final long serialVersionUID = 7603534956639945984L;
    private LocalizedString localizedString;

    public Code() {
        super(new CE(MESSAGE));
    }

    public Code(CE ce) {
        super(ce);
    }

    public Code(String code, LocalizedString displayName, String schemeName) {
        this();
        this.setCode(code);
        this.setDisplayName(displayName);
        this.setSchemeName(schemeName);
    }

    @XmlAttribute
    public String getCode() {
        return ((CE)this.getHapiObject()).getCe1_Identifier().getValue();
    }

    public void setCode(String code) {
        Code.setValue((Primitive)((CE)this.getHapiObject()).getCe1_Identifier(), code);
    }

    @XmlAttribute
    @XmlJavaTypeAdapter(value=LocalizedStringAdapter.class)
    public LocalizedString getDisplayName() {
        String value = ((CE)this.getHapiObject()).getCe2_Text().getValue();
        if (StringUtils.isEmpty((CharSequence)value)) {
            this.localizedString = null;
        } else if (this.localizedString != null) {
            this.localizedString.setValue(value);
        } else {
            this.localizedString = new LocalizedString(value);
        }
        return this.localizedString;
    }

    public void setDisplayName(LocalizedString displayName) {
        this.localizedString = displayName;
        if (displayName != null) {
            Code.setValue((Primitive)((CE)this.getHapiObject()).getCe2_Text(), displayName.getValue());
        } else {
            ((CE)this.getHapiObject()).getCe2_Text().clear();
        }
    }

    @XmlAttribute(name="codeSystemName")
    public String getSchemeName() {
        return ((CE)this.getHapiObject()).getCe3_NameOfCodingSystem().getValue();
    }

    public void setSchemeName(String schemeName) {
        Code.setValue((Primitive)((CE)this.getHapiObject()).getCe3_NameOfCodingSystem(), schemeName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Code that = (Code)o;
        return Objects.equals(this.getCode(), that.getCode()) && Objects.equals(this.getDisplayName(), that.getDisplayName()) && Objects.equals(this.getSchemeName(), that.getSchemeName());
    }

    public int hashCode() {
        return Objects.hash(this.getCode(), this.getDisplayName(), this.getSchemeName());
    }

    public String toString() {
        return "Code(code=" + this.getCode() + ", displayName=" + this.getDisplayName() + ", schemeName=" + this.getSchemeName() + ")";
    }
}

