/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.metadata;

import ca.uhn.hl7v2.Location;
import ca.uhn.hl7v2.model.AbstractType;
import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.MessageVisitor;
import ca.uhn.hl7v2.model.Primitive;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v25.datatype.HD;
import ca.uhn.hl7v2.model.v25.message.ACK;
import ca.uhn.hl7v2.parser.EncodingCharacters;
import ca.uhn.hl7v2.parser.PipeParser;
import com.fasterxml.jackson.annotation.JsonIgnore;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.AssigningAuthority;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.XdsHl7v2Renderer;

@XmlTransient
public abstract class Hl7v2Based<C extends Composite>
implements Serializable {
    private static final long serialVersionUID = 5463666004063275303L;
    protected static final Message MESSAGE = new ACK();
    private final C hapiObject;

    protected Hl7v2Based() {
        throw new IllegalStateException("this default constructor is defined only to satisfy JAXB requirements");
    }

    protected Hl7v2Based(C hapiObject) {
        this.hapiObject = (Composite)Objects.requireNonNull(hapiObject, "HAPI object");
    }

    public static <C extends Composite, T extends Hl7v2Based<C>> T parse(String hl7String, Class<T> xdsModelClass) {
        if (StringUtils.isEmpty((CharSequence)hl7String)) {
            return null;
        }
        Hl7v2Based xdsModelObject = (Hl7v2Based)xdsModelClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        MESSAGE.getParser().parse(xdsModelObject.getHapiObject(), hl7String, XdsHl7v2Renderer.ENCODING_CHARACTERS);
        return (T)(xdsModelObject.isEmpty() ? null : xdsModelObject);
    }

    protected String render() {
        return XdsHl7v2Renderer.encode(this);
    }

    public static String render(Hl7v2Based xdsModelObject) {
        return xdsModelObject != null ? StringUtils.trimToNull((String)xdsModelObject.render()) : null;
    }

    public static String rawRender(Hl7v2Based xdsModelObject) {
        return xdsModelObject != null ? PipeParser.encode(xdsModelObject.getHapiObject(), (EncodingCharacters)XdsHl7v2Renderer.ENCODING_CHARACTERS) : "";
    }

    @JsonIgnore
    public boolean isEmpty() {
        return XdsHl7v2Renderer.isEmpty(this);
    }

    @JsonIgnore
    public C getHapiObject() {
        return this.hapiObject;
    }

    protected static void setValue(Primitive p, String value) {
        if (value == null) {
            p.clear();
        } else {
            p.setValue(value);
        }
    }

    protected static void setValue(Primitive p, Integer value) {
        Hl7v2Based.setValue(p, value == null ? null : value.toString());
    }

    protected static Integer getIntegerValue(Primitive p) {
        String value = p.getValue();
        return StringUtils.isEmpty((CharSequence)value) || "\"\"".equals(value) ? null : Integer.valueOf(Integer.parseInt(value));
    }

    protected static Long getLongValue(Primitive p) {
        String value = p.getValue();
        return StringUtils.isEmpty((CharSequence)value) || "\"\"".equals(value) ? null : Long.valueOf(Long.parseLong(value));
    }

    protected static void setAssigningAuthority(AssigningAuthority assigningAuthority, HD target) {
        if (assigningAuthority != null) {
            HD source = (HD)((Holder)((Object)assigningAuthority.getHapiObject())).getInternal();
            Hl7v2Based.setValue((Primitive)target.getHd1_NamespaceID(), source.getHd1_NamespaceID().getValue());
            Hl7v2Based.setValue((Primitive)target.getHd2_UniversalID(), source.getHd2_UniversalID().getValue());
            Hl7v2Based.setValue((Primitive)target.getHd3_UniversalIDType(), source.getHd3_UniversalIDType().getValue());
        } else {
            target.clear();
        }
    }

    static {
        MESSAGE.getParser().getParserConfiguration().setValidating(false);
    }

    public static class Holder<T extends Type>
    extends AbstractType
    implements Composite {
        private static final long serialVersionUID = -9084300955263787034L;
        private final Type[] data = new Type[1];

        public Holder(T t) {
            super(t.getMessage());
            this.data[0] = t;
        }

        public T getInternal() {
            return (T)this.data[0];
        }

        public Type[] getComponents() {
            return this.data;
        }

        public Type getComponent(int number) throws DataTypeException {
            try {
                return this.data[number];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new DataTypeException("please do not use this class");
            }
        }

        public boolean accept(MessageVisitor visitor, Location currentLocation) {
            return false;
        }
    }
}

