/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Address;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Hl7v2Based;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Identifiable;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Name;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Timestamp;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.XpnName;

public class PatientInfo
implements Serializable {
    private static final long serialVersionUID = 7202574584233259959L;
    private final Map<String, List<String>> stringFields = new HashMap<String, List<String>>();
    private final Map<String, List<? extends Hl7v2Based>> pojoFields = new HashMap<String, List<? extends Hl7v2Based>>();

    public PatientInfo() {
        this.pojoFields.put("PID-3", new ArrayList());
        this.pojoFields.put("PID-5", new ArrayList());
        this.pojoFields.put("PID-7", null);
        this.pojoFields.put("PID-8", null);
        this.pojoFields.put("PID-11", new ArrayList());
    }

    private List<String> getStrings(String fieldId) {
        return this.stringFields.computeIfAbsent(fieldId, dummy -> new ArrayList());
    }

    public Set<String> getAllFieldIds() {
        return new HashSet<String>(this.stringFields.keySet());
    }

    public Set<String> getCustomFieldIds() {
        Set<String> set = this.getAllFieldIds();
        set.removeAll(this.pojoFields.keySet());
        return set;
    }

    public ListIterator<String> getHl7FieldIterator(final String fieldId) {
        ListIterator<String> stringsIterator = this.getStrings(fieldId).listIterator();
        if (!this.pojoFields.containsKey(fieldId)) {
            return stringsIterator;
        }
        List<? extends Hl7v2Based> xdsFields = this.pojoFields.get(fieldId);
        ListIterator<? extends Hl7v2Based> xdsIterator = xdsFields != null ? xdsFields.listIterator() : null;
        return new SynchronizingListIterator<String, Hl7v2Based>(stringsIterator, xdsIterator){

            private void validateParameter(String s) {
                if (s != null && s.contains("~")) {
                    throw new RuntimeException("Repetitions shall be handled by multiple calls to .add()/.set(), and not by the tilde in " + s);
                }
            }

            @Override
            public void set(String s) {
                this.validateParameter(s);
                this.getIterator().set(s);
                switch (fieldId) {
                    case "PID-3": {
                        this.getOtherIterator().set(Hl7v2Based.parse(s, Identifiable.class));
                        break;
                    }
                    case "PID-5": {
                        this.getOtherIterator().set(Hl7v2Based.parse(s, XpnName.class));
                        break;
                    }
                    case "PID-7": 
                    case "PID-8": {
                        break;
                    }
                    case "PID-11": {
                        this.getOtherIterator().set(Hl7v2Based.parse(s, Address.class));
                        break;
                    }
                    default: {
                        throw new IllegalStateException("This line shall be not reachable, please report a bug");
                    }
                }
            }

            @Override
            public void add(String s) {
                this.validateParameter(s);
                this.getIterator().add(s);
                switch (fieldId) {
                    case "PID-3": {
                        this.getOtherIterator().add(Hl7v2Based.parse(s, Identifiable.class));
                        break;
                    }
                    case "PID-5": {
                        this.getOtherIterator().add(Hl7v2Based.parse(s, XpnName.class));
                        break;
                    }
                    case "PID-7": 
                    case "PID-8": {
                        break;
                    }
                    case "PID-11": {
                        this.getOtherIterator().add(Hl7v2Based.parse(s, Address.class));
                        break;
                    }
                    default: {
                        throw new IllegalStateException("This line shall be not reachable, please report a bug");
                    }
                }
            }
        };
    }

    private <T extends Hl7v2Based> ListIterator<T> getXdsFieldIterator(final String fieldId) {
        if (this.pojoFields.get(fieldId) == null) {
            throw new IllegalArgumentException(fieldId + " is not a known repeatable SourcePatientInfo element");
        }
        ListIterator<? extends Hl7v2Based> xdsIterator = this.pojoFields.get(fieldId).listIterator();
        ListIterator<String> stringsIterator = this.getStrings(fieldId).listIterator();
        return new SynchronizingListIterator<T, String>(xdsIterator, stringsIterator){

            private T prepareValue(T xdsObject) {
                if ("PID-5".equals(fieldId) && xdsObject != null && !(xdsObject instanceof XpnName)) {
                    XpnName xpnName = new XpnName();
                    xpnName.copyFrom((Name)xdsObject);
                    return xpnName;
                }
                return xdsObject;
            }

            @Override
            public void set(T xdsObject) {
                xdsObject = this.prepareValue(xdsObject);
                this.getOtherIterator().set(StringUtils.trimToEmpty((String)Hl7v2Based.render(xdsObject)));
                this.getIterator().set(xdsObject);
            }

            @Override
            public void add(T xdsObject) {
                xdsObject = this.prepareValue(xdsObject);
                this.getOtherIterator().add(StringUtils.trimToEmpty((String)Hl7v2Based.render(xdsObject)));
                this.getIterator().add(xdsObject);
            }
        };
    }

    public ListIterator<Identifiable> getIds() {
        return this.getXdsFieldIterator("PID-3");
    }

    public ListIterator<Name> getNames() {
        return this.getXdsFieldIterator("PID-5");
    }

    private String getFirstStringValue(String fieldName) {
        List<String> list = this.stringFields.get(fieldName);
        return list != null && !list.isEmpty() ? list.get(0) : null;
    }

    public Timestamp getDateOfBirth() {
        String s = this.getFirstStringValue("PID-7");
        if (s != null) {
            int pos = s.indexOf(94);
            return Timestamp.fromHL7(pos > 0 ? s.substring(0, pos) : s);
        }
        return null;
    }

    public void setDateOfBirth(Timestamp date) {
        this.setDateOfBirthString(Timestamp.toHL7(date));
    }

    public void setDateOfBirth(String date) {
        this.setDateOfBirthString(StringUtils.stripToNull((String)date));
    }

    private void setDateOfBirthString(String date) {
        List<String> strings = this.getStrings("PID-7");
        strings.clear();
        if (date != null) {
            strings.add(date);
        }
    }

    public String getGender() {
        return StringUtils.stripToNull((String)this.getFirstStringValue("PID-8"));
    }

    public void setGender(String gender) {
        List<String> strings = this.getStrings("PID-8");
        strings.clear();
        String s = StringUtils.stripToNull((String)gender);
        if (s != null) {
            strings.add(s);
        }
    }

    public ListIterator<Address> getAddresses() {
        return this.getXdsFieldIterator("PID-11");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append("PatientInfo(").append("ids=").append(this.pojoFields.get("PID-3")).append(", names=").append(this.pojoFields.get("PID-5")).append(", birthDate=").append(this.getDateOfBirth()).append(", gender=").append(this.getGender()).append(", addresses=").append(this.pojoFields.get("PID-11"));
        this.getCustomFieldIds().stream().sorted(new Hl7FieldIdComparator()).forEach(fieldId -> {
            List<String> values = this.stringFields.get(fieldId);
            if (!values.isEmpty()) {
                sb.append(", ").append((String)fieldId).append('=').append(values);
            }
        });
        return sb.append(')').toString();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PatientInfo)) {
            return false;
        }
        PatientInfo other = (PatientInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, List<String>> this$stringFields = this.stringFields;
        Map<String, List<String>> other$stringFields = other.stringFields;
        if (this$stringFields == null ? other$stringFields != null : !((Object)this$stringFields).equals(other$stringFields)) {
            return false;
        }
        Map<String, List<? extends Hl7v2Based>> this$pojoFields = this.pojoFields;
        Map<String, List<? extends Hl7v2Based>> other$pojoFields = other.pojoFields;
        return !(this$pojoFields == null ? other$pojoFields != null : !((Object)this$pojoFields).equals(other$pojoFields));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PatientInfo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, List<String>> $stringFields = this.stringFields;
        result = result * 59 + ($stringFields == null ? 43 : ((Object)$stringFields).hashCode());
        Map<String, List<? extends Hl7v2Based>> $pojoFields = this.pojoFields;
        result = result * 59 + ($pojoFields == null ? 43 : ((Object)$pojoFields).hashCode());
        return result;
    }

    public static class Hl7FieldIdComparator
    implements Comparator<String> {
        public static final Pattern FIELD_ID_PATTERN = Pattern.compile("([A-Z][A-Z][A-Z0-9])-(\\d\\d?)");

        @Override
        public int compare(String o1, String o2) {
            Matcher matcher1 = FIELD_ID_PATTERN.matcher(o1);
            Matcher matcher2 = FIELD_ID_PATTERN.matcher(o2);
            if (matcher1.matches() && matcher2.matches() && matcher1.group(1).equals(matcher2.group(1))) {
                return Integer.parseInt(matcher1.group(2)) - Integer.parseInt(matcher2.group(2));
            }
            return o1.compareTo(o2);
        }
    }

    private static abstract class SynchronizingListIterator<T, OtherT>
    implements ListIterator<T> {
        private final ListIterator<T> iterator;
        private final ListIterator<OtherT> otherIterator;

        SynchronizingListIterator(ListIterator<T> iterator, ListIterator<OtherT> otherIterator) {
            this.iterator = iterator;
            this.otherIterator = otherIterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            if (this.otherIterator != null) {
                this.otherIterator.next();
            }
            return this.iterator.next();
        }

        @Override
        public boolean hasPrevious() {
            return this.iterator.hasPrevious();
        }

        @Override
        public T previous() {
            if (this.otherIterator != null) {
                this.otherIterator.previous();
            }
            return this.iterator.previous();
        }

        @Override
        public int nextIndex() {
            return this.iterator.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.iterator.previousIndex();
        }

        @Override
        public void remove() {
            if (this.otherIterator != null) {
                this.otherIterator.remove();
            }
            this.iterator.remove();
        }

        @Generated
        protected ListIterator<T> getIterator() {
            return this.iterator;
        }

        @Generated
        protected ListIterator<OtherT> getOtherIterator() {
            return this.otherIterator;
        }
    }
}

