/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.metadata;

import ca.uhn.hl7v2.model.Primitive;
import ca.uhn.hl7v2.model.v25.datatype.XCN;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Objects;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.AssigningAuthority;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Hl7v2Based;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Identifiable;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Name;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.XcnName;

@XmlAccessorType
@XmlType(name="Person", propOrder={"id", "name"})
public class Person
extends Hl7v2Based<XCN> {
    private static final long serialVersionUID = 1775227207521668959L;

    public Person() {
        super(new XCN(MESSAGE));
    }

    public Person(XCN xcn) {
        super(xcn);
    }

    public Person(Identifiable id, Name name) {
        this();
        this.setId(id);
        this.setName(name);
    }

    public Identifiable getId() {
        return new Identifiable(((XCN)this.getHapiObject()).getXcn1_IDNumber().getValue(), new AssigningAuthority(((XCN)this.getHapiObject()).getXcn9_AssigningAuthority()));
    }

    public void setId(Identifiable id) {
        if (id != null) {
            Person.setValue((Primitive)((XCN)this.getHapiObject()).getXcn1_IDNumber(), id.getId());
            Person.setAssigningAuthority(id.getAssigningAuthority(), ((XCN)this.getHapiObject()).getXcn9_AssigningAuthority());
        } else {
            ((XCN)this.getHapiObject()).getXcn1_IDNumber().clear();
            ((XCN)this.getHapiObject()).getXcn9_AssigningAuthority().clear();
        }
    }

    public Name getName() {
        XcnName name = new XcnName((XCN)this.getHapiObject());
        return name.isEmpty() ? null : name;
    }

    public void setName(Name name) {
        if (name != null) {
            XcnName thisName = new XcnName((XCN)this.getHapiObject());
            thisName.copyFrom(name);
        } else {
            XCN xcn = (XCN)this.getHapiObject();
            xcn.getXcn2_FamilyName().clear();
            xcn.getXcn3_GivenName().clear();
            xcn.getXcn4_SecondAndFurtherGivenNamesOrInitialsThereof().clear();
            xcn.getXcn5_SuffixEgJRorIII().clear();
            xcn.getXcn6_PrefixEgDR().clear();
            xcn.getXcn7_DegreeEgMD().clear();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Person that = (Person)o;
        return Objects.equals(this.getId(), that.getId()) && Objects.equals(this.getName(), that.getName());
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.getName());
    }

    public String toString() {
        return "Person(id=" + this.getId() + ", name=" + this.getName() + ")";
    }
}

