/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.metadata;

import ca.uhn.hl7v2.model.DataTypeException;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.openehealth.ipf.commons.ihe.core.HL7DTM;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.jaxbadapters.DateTimeAdapter;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationMessage;
import org.openehealth.ipf.commons.ihe.xds.core.validate.XDSMetaDataException;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Timestamp", propOrder={"dateTime", "precision"})
public class Timestamp
implements Serializable {
    private static final ZoneId UTC_ZONE_ID = ZoneId.of("UTC");
    private static final long serialVersionUID = 4324651691599629794L;
    private static final Map<Precision, DateTimeFormatter> FORMATTERS = new EnumMap<Precision, DateTimeFormatter>(Precision.class);
    @XmlAttribute
    @XmlJavaTypeAdapter(value=DateTimeAdapter.class)
    private ZonedDateTime dateTime;
    @XmlAttribute
    private Precision precision;

    public Timestamp() {
    }

    public Timestamp(ZonedDateTime dateTime, Precision precision) {
        this.setDateTime(dateTime);
        this.setPrecision(precision);
    }

    public static Timestamp fromHL7(String s) {
        int len;
        if (StringUtils.isEmpty((CharSequence)s)) {
            return null;
        }
        int pos = Math.max(s.indexOf(45), s.indexOf(43));
        int n = len = pos >= 0 ? pos : s.length();
        Precision precision = len >= 14 ? Precision.SECOND : (len >= 12 ? Precision.MINUTE : (len >= 10 ? Precision.HOUR : (len >= 8 ? Precision.DAY : (len >= 6 ? Precision.MONTH : Precision.YEAR))));
        try {
            return new Timestamp(HL7DTM.toZonedDateTime((String)s), precision);
        }
        catch (DataTypeException e) {
            throw new XDSMetaDataException(ValidationMessage.INVALID_TIME, s);
        }
    }

    public static String toHL7(Timestamp timestamp) {
        return timestamp != null ? timestamp.toHL7() : null;
    }

    public String toHL7() {
        return FORMATTERS.get((Object)this.getPrecision()).format(this.getDateTime());
    }

    public void setDateTime(ZonedDateTime dateTime) {
        this.dateTime = dateTime != null ? dateTime.withZoneSameInstant(UTC_ZONE_ID) : null;
    }

    public Precision getPrecision() {
        return this.precision != null ? this.precision : Precision.SECOND;
    }

    public static Timestamp now() {
        return new Timestamp(ZonedDateTime.now(), Precision.SECOND);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Timestamp timestamp = (Timestamp)o;
        return StringUtils.equals((CharSequence)Timestamp.toHL7(this), (CharSequence)Timestamp.toHL7(timestamp));
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dateTime, this.precision});
    }

    public String toString() {
        return "Timestamp(dateTime=" + this.dateTime + ", precision=" + this.precision + ")";
    }

    @Generated
    public ZonedDateTime getDateTime() {
        return this.dateTime;
    }

    @Generated
    public void setPrecision(Precision precision) {
        this.precision = precision;
    }

    static {
        FORMATTERS.put(Precision.YEAR, DateTimeFormatter.ofPattern("yyyy"));
        FORMATTERS.put(Precision.MONTH, DateTimeFormatter.ofPattern("yyyyMM"));
        FORMATTERS.put(Precision.DAY, DateTimeFormatter.ofPattern("yyyyMMdd"));
        FORMATTERS.put(Precision.HOUR, DateTimeFormatter.ofPattern("yyyyMMddHH"));
        FORMATTERS.put(Precision.MINUTE, DateTimeFormatter.ofPattern("yyyyMMddHHmm"));
        FORMATTERS.put(Precision.SECOND, DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
    }

    @XmlEnum
    @XmlType(name="Precision", namespace="http://www.openehealth.org/ipf/xds")
    public static enum Precision {
        YEAR,
        MONTH,
        DAY,
        HOUR,
        MINUTE,
        SECOND;

    }
}

