/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.requests.query;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.List;
import lombok.Generated;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.AvailabilityStatus;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Code;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Hl7v2Based;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Identifiable;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Person;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.TimeRange;
import org.openehealth.ipf.commons.ihe.xds.core.requests.query.PatientIdBasedStoredQuery;
import org.openehealth.ipf.commons.ihe.xds.core.requests.query.Query;
import org.openehealth.ipf.commons.ihe.xds.core.requests.query.QueryType;
import org.openehealth.ipf.commons.ihe.xds.core.requests.query.StoredQuery;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="FindSubmissionSetsQuery", propOrder={"status", "sourceIds", "authorPerson", "submissionTime", "contentTypeCodes", "patientId"})
@XmlRootElement(name="findSubmissionSetsQuery")
public class FindSubmissionSetsQuery
extends StoredQuery
implements PatientIdBasedStoredQuery {
    private static final long serialVersionUID = 1712346604151312305L;
    private List<AvailabilityStatus> status;
    @XmlElement(name="sourceId")
    private List<String> sourceIds;
    @XmlElement(name="contentTypeCode")
    private List<Code> contentTypeCodes;
    private String authorPerson;
    private Identifiable patientId;
    private final TimeRange submissionTime = new TimeRange();

    public FindSubmissionSetsQuery() {
        super(QueryType.FIND_SUBMISSION_SETS);
    }

    @Override
    public void accept(Query.Visitor visitor) {
        visitor.visit(this);
    }

    public void setTypedAuthorPerson(Person authorPerson) {
        this.authorPerson = Hl7v2Based.render(authorPerson);
    }

    public Person getTypedAuthorPerson() {
        return Hl7v2Based.parse(this.authorPerson, Person.class);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindSubmissionSetsQuery)) {
            return false;
        }
        FindSubmissionSetsQuery other = (FindSubmissionSetsQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<AvailabilityStatus> this$status = this.status;
        List<AvailabilityStatus> other$status = other.status;
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        List<String> this$sourceIds = this.sourceIds;
        List<String> other$sourceIds = other.sourceIds;
        if (this$sourceIds == null ? other$sourceIds != null : !((Object)this$sourceIds).equals(other$sourceIds)) {
            return false;
        }
        List<Code> this$contentTypeCodes = this.contentTypeCodes;
        List<Code> other$contentTypeCodes = other.contentTypeCodes;
        if (this$contentTypeCodes == null ? other$contentTypeCodes != null : !((Object)this$contentTypeCodes).equals(other$contentTypeCodes)) {
            return false;
        }
        String this$authorPerson = this.authorPerson;
        String other$authorPerson = other.authorPerson;
        if (this$authorPerson == null ? other$authorPerson != null : !this$authorPerson.equals(other$authorPerson)) {
            return false;
        }
        Identifiable this$patientId = this.patientId;
        Identifiable other$patientId = other.patientId;
        if (this$patientId == null ? other$patientId != null : !((Object)this$patientId).equals(other$patientId)) {
            return false;
        }
        TimeRange this$submissionTime = this.submissionTime;
        TimeRange other$submissionTime = other.submissionTime;
        return !(this$submissionTime == null ? other$submissionTime != null : !((Object)this$submissionTime).equals(other$submissionTime));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FindSubmissionSetsQuery;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<AvailabilityStatus> $status = this.status;
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        List<String> $sourceIds = this.sourceIds;
        result = result * 59 + ($sourceIds == null ? 43 : ((Object)$sourceIds).hashCode());
        List<Code> $contentTypeCodes = this.contentTypeCodes;
        result = result * 59 + ($contentTypeCodes == null ? 43 : ((Object)$contentTypeCodes).hashCode());
        String $authorPerson = this.authorPerson;
        result = result * 59 + ($authorPerson == null ? 43 : $authorPerson.hashCode());
        Identifiable $patientId = this.patientId;
        result = result * 59 + ($patientId == null ? 43 : ((Object)$patientId).hashCode());
        TimeRange $submissionTime = this.submissionTime;
        result = result * 59 + ($submissionTime == null ? 43 : ((Object)$submissionTime).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "FindSubmissionSetsQuery(super=" + super.toString() + ", status=" + this.status + ", sourceIds=" + this.sourceIds + ", contentTypeCodes=" + this.contentTypeCodes + ", authorPerson=" + this.authorPerson + ", patientId=" + this.patientId + ", submissionTime=" + this.submissionTime + ")";
    }

    @Generated
    public List<AvailabilityStatus> getStatus() {
        return this.status;
    }

    @Generated
    public void setStatus(List<AvailabilityStatus> status) {
        this.status = status;
    }

    @Generated
    public List<String> getSourceIds() {
        return this.sourceIds;
    }

    @Generated
    public void setSourceIds(List<String> sourceIds) {
        this.sourceIds = sourceIds;
    }

    @Generated
    public List<Code> getContentTypeCodes() {
        return this.contentTypeCodes;
    }

    @Generated
    public void setContentTypeCodes(List<Code> contentTypeCodes) {
        this.contentTypeCodes = contentTypeCodes;
    }

    @Generated
    public String getAuthorPerson() {
        return this.authorPerson;
    }

    @Generated
    public void setAuthorPerson(String authorPerson) {
        this.authorPerson = authorPerson;
    }

    @Override
    @Generated
    public Identifiable getPatientId() {
        return this.patientId;
    }

    @Override
    @Generated
    public void setPatientId(Identifiable patientId) {
        this.patientId = patientId;
    }

    @Generated
    public TimeRange getSubmissionTime() {
        return this.submissionTime;
    }
}

