/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.responses;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.util.Objects;
import lombok.Generated;
import org.openehealth.ipf.commons.ihe.xds.core.XdsRuntimeException;
import org.openehealth.ipf.commons.ihe.xds.core.responses.ErrorCode;
import org.openehealth.ipf.commons.ihe.xds.core.responses.Severity;
import org.openehealth.ipf.commons.ihe.xds.core.validate.XDSMetaDataException;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ErrorInfo", propOrder={"errorCode", "codeContext", "severity", "location", "customErrorCode"})
public class ErrorInfo
implements Serializable {
    private static final long serialVersionUID = 7615868122051414551L;
    private ErrorCode errorCode;
    private String codeContext;
    private Severity severity;
    private String location;
    private String customErrorCode;

    public ErrorInfo() {
    }

    public ErrorInfo(ErrorCode errorCode, String codeContext, Severity severity, String location, String customErrorCode) {
        this.errorCode = errorCode;
        this.codeContext = codeContext;
        this.severity = severity;
        this.location = location;
        this.customErrorCode = customErrorCode;
    }

    public ErrorInfo(Throwable throwable, ErrorCode defaultMetaDataError, ErrorCode defaultError, String defaultLocation) {
        this(defaultError, throwable.getMessage(), Severity.ERROR, defaultLocation, null);
        for (Throwable t = throwable; t != null; t = t.getCause()) {
            if (t instanceof XDSMetaDataException) {
                XDSMetaDataException metaDataException = (XDSMetaDataException)((Object)t);
                this.errorCode = metaDataException.getValidationMessage().getErrorCode();
                if (this.errorCode == null) {
                    this.errorCode = defaultMetaDataError;
                }
                this.codeContext = metaDataException.getMessage();
                return;
            }
            if (!(t instanceof XdsRuntimeException)) continue;
            XdsRuntimeException exception = (XdsRuntimeException)t;
            this.errorCode = exception.getErrorCode();
            this.codeContext = exception.getCodeContext();
            this.severity = exception.getSeverity();
            this.location = exception.getLocation();
            return;
        }
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(ErrorCode errorCode) {
        this.errorCode = errorCode;
    }

    public String getCodeContext() {
        return this.codeContext;
    }

    public void setCodeContext(String codeContext) {
        this.codeContext = codeContext;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public void setSeverity(Severity severity) {
        this.severity = severity;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getCustomErrorCode() {
        return this.customErrorCode;
    }

    public void setCustomErrorCode(String customErrorCode) {
        this.customErrorCode = customErrorCode;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.codeContext, this.errorCode, this.location, this.severity, this.customErrorCode});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ErrorInfo other = (ErrorInfo)obj;
        if (!Objects.equals(this.codeContext, other.codeContext)) {
            return false;
        }
        if (!Objects.equals((Object)this.errorCode, (Object)other.errorCode)) {
            return false;
        }
        if (!Objects.equals(this.location, other.location)) {
            return false;
        }
        if (!Objects.equals((Object)this.severity, (Object)other.severity)) {
            return false;
        }
        if (this.customErrorCode == null) {
            return other.customErrorCode == null;
        }
        return this.customErrorCode.equals(other.customErrorCode);
    }

    @Generated
    public String toString() {
        return "ErrorInfo(errorCode=" + this.errorCode + ", codeContext=" + this.codeContext + ", severity=" + this.severity + ", location=" + this.location + ", customErrorCode=" + this.customErrorCode + ")";
    }
}

