/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.transform.ebxml;

import java.util.List;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLClassification;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLFactory;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLObjectLibrary;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLRegistryPackage;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Code;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Folder;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Timestamp;
import org.openehealth.ipf.commons.ihe.xds.core.transform.ebxml.CodeTransformer;
import org.openehealth.ipf.commons.ihe.xds.core.transform.ebxml.XDSMetaClassTransformer;

public class FolderTransformer
extends XDSMetaClassTransformer<EbXMLRegistryPackage, Folder> {
    private final CodeTransformer codeTransformer;

    public FolderTransformer(EbXMLFactory factory) {
        super("urn:uuid:f64ffdf0-4b97-4e06-b79f-a52b38ec2f8a", "XDSFolder.patientId", "urn:uuid:75df8f67-9973-4fbe-a900-df66cefecc5a", "XDSFolder.uniqueId", "urn:uuid:2c144a76-29a9-4b7c-af54-b25409fe7d03", factory);
        this.codeTransformer = new CodeTransformer(factory);
    }

    @Override
    protected EbXMLRegistryPackage createEbXMLInstance(String id, EbXMLObjectLibrary objectLibrary) {
        return this.factory.createRegistryPackage(id, objectLibrary);
    }

    @Override
    protected Folder createMetaClassInstance() {
        return new Folder();
    }

    @Override
    protected void addAttributes(Folder metaData, EbXMLRegistryPackage ebXML, EbXMLObjectLibrary objectLibrary) {
        super.addAttributes(metaData, ebXML, objectLibrary);
        ebXML.setStatus(metaData.getAvailabilityStatus());
        ebXML.setHome(metaData.getHomeCommunityId());
    }

    @Override
    protected void addAttributesFromEbXML(Folder metaData, EbXMLRegistryPackage ebXML) {
        super.addAttributesFromEbXML(metaData, ebXML);
        metaData.setAvailabilityStatus(ebXML.getStatus());
        metaData.setHomeCommunityId(ebXML.getHome());
    }

    @Override
    protected void addSlotsFromEbXML(Folder folder, EbXMLRegistryPackage regPackage) {
        super.addSlotsFromEbXML(folder, regPackage);
        folder.setLastUpdateTime(regPackage.getSingleSlotValue("lastUpdateTime"));
    }

    @Override
    protected void addSlots(Folder folder, EbXMLRegistryPackage regPackage, EbXMLObjectLibrary objectLibrary) {
        super.addSlots(folder, regPackage, objectLibrary);
        regPackage.addSlot("lastUpdateTime", Timestamp.toHL7(folder.getLastUpdateTime()));
    }

    @Override
    protected void addClassificationsFromEbXML(Folder folder, EbXMLRegistryPackage regPackage) {
        super.addClassificationsFromEbXML(folder, regPackage);
        List<Code> codes = folder.getCodeList();
        codes.addAll(regPackage.getClassifications("urn:uuid:1ba97051-7806-41a8-a48b-8fce7af683c5").stream().map(this.codeTransformer::fromEbXML).toList());
    }

    @Override
    protected void addClassifications(Folder folder, EbXMLRegistryPackage regPackage, EbXMLObjectLibrary objectLibrary) {
        super.addClassifications(folder, regPackage, objectLibrary);
        folder.getCodeList().stream().map(codeListElem -> this.codeTransformer.toEbXML((Code)codeListElem, objectLibrary)).forEach(code -> regPackage.addClassification((EbXMLClassification)code, "urn:uuid:1ba97051-7806-41a8-a48b-8fce7af683c5"));
    }
}

