/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.transform.ebxml;

import java.util.List;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLClassification;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLFactory;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLObjectLibrary;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLRegistryPackage;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Author;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Recipient;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.SubmissionSet;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Timestamp;
import org.openehealth.ipf.commons.ihe.xds.core.transform.ebxml.AuthorTransformer;
import org.openehealth.ipf.commons.ihe.xds.core.transform.ebxml.CodeTransformer;
import org.openehealth.ipf.commons.ihe.xds.core.transform.ebxml.RecipientTransformer;
import org.openehealth.ipf.commons.ihe.xds.core.transform.ebxml.XDSMetaClassTransformer;

public class SubmissionSetTransformer
extends XDSMetaClassTransformer<EbXMLRegistryPackage, SubmissionSet> {
    private final AuthorTransformer authorTransformer;
    private final CodeTransformer codeTransformer;
    private final RecipientTransformer recipientTransformer = new RecipientTransformer();

    public SubmissionSetTransformer(EbXMLFactory factory) {
        super("urn:uuid:6b5aea1a-874d-4603-a4bc-96a0a7b38446", "XDSSubmissionSet.patientId", "urn:uuid:96fdda7c-d067-4183-912e-bf5ee74998a8", "XDSSubmissionSet.uniqueId", "urn:uuid:5003a9db-8d8d-49e6-bf0c-990e34ac7707", factory);
        this.authorTransformer = new AuthorTransformer(factory);
        this.codeTransformer = new CodeTransformer(factory);
    }

    @Override
    protected EbXMLRegistryPackage createEbXMLInstance(String id, EbXMLObjectLibrary objectLibrary) {
        return this.factory.createRegistryPackage(id, objectLibrary);
    }

    @Override
    protected SubmissionSet createMetaClassInstance() {
        return new SubmissionSet();
    }

    @Override
    protected void addAttributes(SubmissionSet metaData, EbXMLRegistryPackage ebXML, EbXMLObjectLibrary objectLibrary) {
        super.addAttributes(metaData, ebXML, objectLibrary);
        ebXML.setStatus(metaData.getAvailabilityStatus());
        ebXML.setHome(metaData.getHomeCommunityId());
    }

    @Override
    protected void addAttributesFromEbXML(SubmissionSet metaData, EbXMLRegistryPackage ebXML) {
        super.addAttributesFromEbXML(metaData, ebXML);
        metaData.setAvailabilityStatus(ebXML.getStatus());
        metaData.setHomeCommunityId(ebXML.getHome());
    }

    @Override
    protected void addSlots(SubmissionSet metaData, EbXMLRegistryPackage ebXML, EbXMLObjectLibrary objectLibrary) {
        super.addSlots(metaData, ebXML, objectLibrary);
        String[] slotValues = (String[])metaData.getIntendedRecipients().stream().map(this.recipientTransformer::toEbXML).toArray(String[]::new);
        ebXML.addSlot("intendedRecipient", slotValues);
        ebXML.addSlot("submissionTime", Timestamp.toHL7(metaData.getSubmissionTime()));
    }

    @Override
    protected void addSlotsFromEbXML(SubmissionSet metaData, EbXMLRegistryPackage ebXML) {
        super.addSlotsFromEbXML(metaData, ebXML);
        List<Recipient> recipients = metaData.getIntendedRecipients();
        recipients.addAll(ebXML.getSlotValues("intendedRecipient").stream().map(this.recipientTransformer::fromEbXML).toList());
        metaData.setSubmissionTime(ebXML.getSingleSlotValue("submissionTime"));
    }

    @Override
    protected void addClassificationsFromEbXML(SubmissionSet set, EbXMLRegistryPackage regPackage) {
        super.addClassificationsFromEbXML(set, regPackage);
        regPackage.getClassifications("urn:uuid:a7058bb9-b4e4-4307-ba5b-e3f0ab85e12d").forEach(author -> set.getAuthors().add(this.authorTransformer.fromEbXML((EbXMLClassification)author)));
        EbXMLClassification contentType = regPackage.getSingleClassification("urn:uuid:aa543740-bdda-424e-8c96-df4873be8500");
        set.setContentTypeCode(this.codeTransformer.fromEbXML(contentType));
    }

    @Override
    protected void addClassifications(SubmissionSet set, EbXMLRegistryPackage regPackage, EbXMLObjectLibrary objectLibrary) {
        super.addClassifications(set, regPackage, objectLibrary);
        set.getAuthors().stream().map(author -> this.authorTransformer.toEbXML((Author)author, objectLibrary)).forEach(authorClassification -> regPackage.addClassification((EbXMLClassification)authorClassification, "urn:uuid:a7058bb9-b4e4-4307-ba5b-e3f0ab85e12d"));
        EbXMLClassification contentType = this.codeTransformer.toEbXML(set.getContentTypeCode(), objectLibrary);
        regPackage.addClassification(contentType, "urn:uuid:aa543740-bdda-424e-8c96-df4873be8500");
    }

    @Override
    protected void addExternalIdentifiers(SubmissionSet metaData, EbXMLRegistryPackage ebXML, EbXMLObjectLibrary objectLibrary) {
        super.addExternalIdentifiers(metaData, ebXML, objectLibrary);
        ebXML.addExternalIdentifier(metaData.getSourceId(), "urn:uuid:554ac39e-e3fe-47fe-b233-965d2a147832", "XDSSubmissionSet.sourceId");
    }

    @Override
    protected void addExternalIdentifiersFromEbXML(SubmissionSet metaData, EbXMLRegistryPackage ebXML) {
        super.addExternalIdentifiersFromEbXML(metaData, ebXML);
        String sourceID = ebXML.getExternalIdentifierValue("urn:uuid:554ac39e-e3fe-47fe-b233-965d2a147832");
        metaData.setSourceId(sourceID);
    }
}

