/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.transform.requests.query;

import org.openehealth.ipf.commons.ihe.xds.core.metadata.Hl7v2Based;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Identifiable;
import org.openehealth.ipf.commons.ihe.xds.core.requests.query.FindDocumentsQuery;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.QueryParameter;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.query.DocumentsQueryTransformer;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.query.QuerySlotHelper;

public class AbstractFindDocumentsQueryTransformer<T extends FindDocumentsQuery>
extends DocumentsQueryTransformer<T> {
    protected AbstractFindDocumentsQueryTransformer() {
    }

    @Override
    protected void toEbXML(T query, QuerySlotHelper slots) {
        super.toEbXML(query, slots);
        slots.fromString(QueryParameter.DOC_ENTRY_PATIENT_ID, Hl7v2Based.render(((FindDocumentsQuery)query).getPatientId()));
        slots.fromDocumentEntryType(QueryParameter.DOC_ENTRY_TYPE, ((FindDocumentsQuery)query).getDocumentEntryTypes());
        slots.fromStatus(QueryParameter.DOC_ENTRY_STATUS, ((FindDocumentsQuery)query).getStatus());
        slots.fromDocumentAvailability(QueryParameter.DOC_ENTRY_DOCUMENT_AVAILABILITY, ((FindDocumentsQuery)query).getDocumentAvailability());
        slots.fromInteger(QueryParameter.METADATA_LEVEL, ((FindDocumentsQuery)query).getMetadataLevel());
    }

    @Override
    protected void fromEbXML(T query, QuerySlotHelper slots) {
        super.fromEbXML(query, slots);
        String patientId = slots.toString(QueryParameter.DOC_ENTRY_PATIENT_ID);
        ((FindDocumentsQuery)query).setPatientId(Hl7v2Based.parse(patientId, Identifiable.class));
        ((FindDocumentsQuery)query).setDocumentEntryTypes(slots.toDocumentEntryType(QueryParameter.DOC_ENTRY_TYPE));
        ((FindDocumentsQuery)query).setStatus(slots.toStatus(QueryParameter.DOC_ENTRY_STATUS));
        ((FindDocumentsQuery)query).setDocumentAvailability(slots.toDocumentAvailability(QueryParameter.DOC_ENTRY_DOCUMENT_AVAILABILITY));
        ((FindDocumentsQuery)query).setMetadataLevel(slots.toInteger(QueryParameter.METADATA_LEVEL));
    }
}

