/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.transform.requests.query;

import org.openehealth.ipf.commons.ihe.xds.core.requests.query.DocumentsQuery;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.QueryParameter;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.query.AbstractStoredQueryTransformer;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.query.QuerySlotHelper;

abstract class DocumentsQueryTransformer<T extends DocumentsQuery>
extends AbstractStoredQueryTransformer<T> {
    DocumentsQueryTransformer() {
    }

    @Override
    protected void toEbXML(T query, QuerySlotHelper slots) {
        super.toEbXML(query, slots);
        slots.fromStringList(QueryParameter.DOC_ENTRY_AUTHOR_PERSON, ((DocumentsQuery)query).getAuthorPersons());
        slots.fromTimestamp(QueryParameter.DOC_ENTRY_CREATION_TIME_FROM, ((DocumentsQuery)query).getCreationTime().getFrom());
        slots.fromTimestamp(QueryParameter.DOC_ENTRY_CREATION_TIME_TO, ((DocumentsQuery)query).getCreationTime().getTo());
        slots.fromTimestamp(QueryParameter.DOC_ENTRY_SERVICE_START_TIME_FROM, ((DocumentsQuery)query).getServiceStartTime().getFrom());
        slots.fromTimestamp(QueryParameter.DOC_ENTRY_SERVICE_START_TIME_TO, ((DocumentsQuery)query).getServiceStartTime().getTo());
        slots.fromTimestamp(QueryParameter.DOC_ENTRY_SERVICE_STOP_TIME_FROM, ((DocumentsQuery)query).getServiceStopTime().getFrom());
        slots.fromTimestamp(QueryParameter.DOC_ENTRY_SERVICE_STOP_TIME_TO, ((DocumentsQuery)query).getServiceStopTime().getTo());
        slots.fromCode(QueryParameter.DOC_ENTRY_FORMAT_CODE, ((DocumentsQuery)query).getFormatCodes());
        slots.fromCode(QueryParameter.DOC_ENTRY_CLASS_CODE, ((DocumentsQuery)query).getClassCodes());
        slots.fromCode(QueryParameter.DOC_ENTRY_TYPE_CODE, ((DocumentsQuery)query).getTypeCodes());
        slots.fromCode(QueryParameter.DOC_ENTRY_HEALTHCARE_FACILITY_TYPE_CODE, ((DocumentsQuery)query).getHealthcareFacilityTypeCodes());
        slots.fromCode(QueryParameter.DOC_ENTRY_PRACTICE_SETTING_CODE, ((DocumentsQuery)query).getPracticeSettingCodes());
        slots.fromCode(QueryParameter.DOC_ENTRY_EVENT_CODE, ((DocumentsQuery)query).getEventCodes());
        slots.fromCode(QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE, ((DocumentsQuery)query).getConfidentialityCodes());
    }

    @Override
    protected void fromEbXML(T query, QuerySlotHelper slots) {
        super.fromEbXML(query, slots);
        ((DocumentsQuery)query).setClassCodes(slots.toCodeList(QueryParameter.DOC_ENTRY_CLASS_CODE));
        ((DocumentsQuery)query).setTypeCodes(slots.toCodeList(QueryParameter.DOC_ENTRY_TYPE_CODE));
        ((DocumentsQuery)query).setPracticeSettingCodes(slots.toCodeList(QueryParameter.DOC_ENTRY_PRACTICE_SETTING_CODE));
        ((DocumentsQuery)query).setHealthcareFacilityTypeCodes(slots.toCodeList(QueryParameter.DOC_ENTRY_HEALTHCARE_FACILITY_TYPE_CODE));
        ((DocumentsQuery)query).setFormatCodes(slots.toCodeList(QueryParameter.DOC_ENTRY_FORMAT_CODE));
        ((DocumentsQuery)query).setEventCodes(slots.toCodeQueryList(QueryParameter.DOC_ENTRY_EVENT_CODE, QueryParameter.DOC_ENTRY_EVENT_CODE_SCHEME));
        ((DocumentsQuery)query).setConfidentialityCodes(slots.toCodeQueryList(QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE, QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE_SCHEME));
        ((DocumentsQuery)query).setAuthorPersons(slots.toStringList(QueryParameter.DOC_ENTRY_AUTHOR_PERSON));
        ((DocumentsQuery)query).getCreationTime().setFrom(slots.toTimestamp(QueryParameter.DOC_ENTRY_CREATION_TIME_FROM));
        ((DocumentsQuery)query).getCreationTime().setTo(slots.toTimestamp(QueryParameter.DOC_ENTRY_CREATION_TIME_TO));
        ((DocumentsQuery)query).getServiceStartTime().setFrom(slots.toTimestamp(QueryParameter.DOC_ENTRY_SERVICE_START_TIME_FROM));
        ((DocumentsQuery)query).getServiceStartTime().setTo(slots.toTimestamp(QueryParameter.DOC_ENTRY_SERVICE_START_TIME_TO));
        ((DocumentsQuery)query).getServiceStopTime().setFrom(slots.toTimestamp(QueryParameter.DOC_ENTRY_SERVICE_STOP_TIME_FROM));
        ((DocumentsQuery)query).getServiceStopTime().setTo(slots.toTimestamp(QueryParameter.DOC_ENTRY_SERVICE_STOP_TIME_TO));
    }
}

