/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.transform.requests.query;

import lombok.Generated;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Hl7v2Based;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Identifiable;
import org.openehealth.ipf.commons.ihe.xds.core.requests.query.GetAllQuery;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.QueryParameter;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.query.AbstractStoredQueryTransformer;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.query.QuerySlotHelper;

public class GetAllQueryTransformer
extends AbstractStoredQueryTransformer<GetAllQuery> {
    private static final GetAllQueryTransformer instance = new GetAllQueryTransformer();

    private GetAllQueryTransformer() {
    }

    @Override
    protected void toEbXML(GetAllQuery query, QuerySlotHelper slots) {
        super.toEbXML(query, slots);
        slots.fromString(QueryParameter.PATIENT_ID, Hl7v2Based.render(query.getPatientId()));
        slots.fromStatus(QueryParameter.DOC_ENTRY_STATUS, query.getStatusDocuments());
        slots.fromStatus(QueryParameter.SUBMISSION_SET_STATUS, query.getStatusSubmissionSets());
        slots.fromStatus(QueryParameter.FOLDER_STATUS, query.getStatusFolders());
        slots.fromCode(QueryParameter.DOC_ENTRY_FORMAT_CODE, query.getFormatCodes());
        slots.fromCode(QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE, query.getConfidentialityCodes());
        slots.fromDocumentEntryType(QueryParameter.DOC_ENTRY_TYPE, query.getDocumentEntryTypes());
        slots.fromStatus(QueryParameter.ASSOCIATION_STATUS, query.getAssociationStatuses());
        slots.fromInteger(QueryParameter.METADATA_LEVEL, query.getMetadataLevel());
    }

    @Override
    protected void fromEbXML(GetAllQuery query, QuerySlotHelper slots) {
        super.fromEbXML(query, slots);
        String patientId = slots.toString(QueryParameter.PATIENT_ID);
        query.setPatientId(Hl7v2Based.parse(patientId, Identifiable.class));
        query.setStatusDocuments(slots.toStatus(QueryParameter.DOC_ENTRY_STATUS));
        query.setStatusFolders(slots.toStatus(QueryParameter.FOLDER_STATUS));
        query.setStatusSubmissionSets(slots.toStatus(QueryParameter.SUBMISSION_SET_STATUS));
        query.setConfidentialityCodes(slots.toCodeQueryList(QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE, QueryParameter.DOC_ENTRY_CONFIDENTIALITY_CODE_SCHEME));
        query.setFormatCodes(slots.toCodeList(QueryParameter.DOC_ENTRY_FORMAT_CODE));
        query.setDocumentEntryTypes(slots.toDocumentEntryType(QueryParameter.DOC_ENTRY_TYPE));
        query.setAssociationStatuses(slots.toStatus(QueryParameter.ASSOCIATION_STATUS));
        query.setMetadataLevel(slots.toInteger(QueryParameter.METADATA_LEVEL));
    }

    @Generated
    public static GetAllQueryTransformer getInstance() {
        return instance;
    }
}

