/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.transform.requests.query;

import lombok.Generated;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Hl7v2Based;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Identifiable;
import org.openehealth.ipf.commons.ihe.xds.core.requests.query.SubscriptionForFolderQuery;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.QueryParameter;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.query.GetByIDQueryTransformer;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.query.QuerySlotHelper;

public class SubscriptionForFolderQueryTransformer
extends GetByIDQueryTransformer<SubscriptionForFolderQuery> {
    private static final SubscriptionForFolderQueryTransformer instance = new SubscriptionForFolderQueryTransformer();

    private SubscriptionForFolderQueryTransformer() {
        super(QueryParameter.FOLDER_UUID, QueryParameter.FOLDER_UNIQUE_ID);
    }

    @Override
    protected void toEbXML(SubscriptionForFolderQuery query, QuerySlotHelper slots) {
        super.toEbXML(query, slots);
        slots.fromString(QueryParameter.FOLDER_PATIENT_ID, Hl7v2Based.render(query.getPatientId()));
        slots.fromCode(QueryParameter.FOLDER_CODES, query.getCodes());
        slots.fromStringList(QueryParameter.FOLDER_LOGICAL_ID, query.getLogicalUuid());
    }

    @Override
    protected void fromEbXML(SubscriptionForFolderQuery query, QuerySlotHelper slots) {
        super.fromEbXML(query, slots);
        String patientId = slots.toString(QueryParameter.FOLDER_PATIENT_ID);
        query.setPatientId(Hl7v2Based.parse(patientId, Identifiable.class));
        query.setCodes(slots.toCodeQueryList(QueryParameter.FOLDER_CODES, QueryParameter.FOLDER_CODES_SCHEME));
        query.setLogicalUuid(slots.toStringList(QueryParameter.FOLDER_LOGICAL_ID));
    }

    @Generated
    public static SubscriptionForFolderQueryTransformer getInstance() {
        return instance;
    }
}

