/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.transform.requests.query;

import lombok.Generated;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Hl7v2Based;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Identifiable;
import org.openehealth.ipf.commons.ihe.xds.core.requests.query.SubscriptionForSubmissionSetQuery;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.QueryParameter;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.query.AbstractStoredQueryTransformer;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.query.QuerySlotHelper;

public class SubscriptionForSubmissionSetQueryTransformer
extends AbstractStoredQueryTransformer<SubscriptionForSubmissionSetQuery> {
    private static final SubscriptionForSubmissionSetQueryTransformer instance = new SubscriptionForSubmissionSetQueryTransformer();

    private SubscriptionForSubmissionSetQueryTransformer() {
    }

    @Override
    protected void toEbXML(SubscriptionForSubmissionSetQuery query, QuerySlotHelper slots) {
        super.toEbXML(query, slots);
        slots.fromString(QueryParameter.SUBMISSION_SET_PATIENT_ID, Hl7v2Based.render(query.getPatientId()));
        slots.fromStringList(QueryParameter.SUBMISSION_SET_SOURCE_ID, query.getSourceIds());
        slots.fromStringList(QueryParameter.SUBMISSION_SET_AUTHOR_PERSON, query.getAuthorPersons());
        slots.fromStringList(QueryParameter.SUBMISSION_SET_INTENDED_RECIPIENT, query.getIntendedRecipients());
    }

    @Override
    protected void fromEbXML(SubscriptionForSubmissionSetQuery query, QuerySlotHelper slots) {
        super.fromEbXML(query, slots);
        String patientId = slots.toString(QueryParameter.SUBMISSION_SET_PATIENT_ID);
        query.setPatientId(Hl7v2Based.parse(patientId, Identifiable.class));
        query.setSourceIds(slots.toStringList(QueryParameter.SUBMISSION_SET_SOURCE_ID));
        query.setAuthorPersons(slots.toStringList(QueryParameter.SUBMISSION_SET_AUTHOR_PERSON));
        query.setIntendedRecipients(slots.toStringList(QueryParameter.SUBMISSION_SET_INTENDED_RECIPIENT));
    }

    @Generated
    public static SubscriptionForSubmissionSetQueryTransformer getInstance() {
        return instance;
    }
}

