/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.transform.responses;

import java.util.List;
import java.util.Objects;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLFactory;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLRegistryError;
import org.openehealth.ipf.commons.ihe.xds.core.responses.ErrorCode;
import org.openehealth.ipf.commons.ihe.xds.core.responses.ErrorInfo;

public class ErrorInfoListTransformer {
    private final EbXMLFactory factory;

    public ErrorInfoListTransformer(EbXMLFactory factory) {
        this.factory = Objects.requireNonNull(factory, "ebXML factory must be not null");
    }

    public List<EbXMLRegistryError> toEbXML(List<ErrorInfo> errorInfoList) {
        Objects.requireNonNull(errorInfoList, "error info list cannot be null");
        return errorInfoList.stream().map(this::toEbXML).toList();
    }

    public List<ErrorInfo> fromEbXML(List<EbXMLRegistryError> registryErrorList) {
        Objects.requireNonNull(registryErrorList, "registry error list cannot be null");
        return registryErrorList.stream().map(this::fromEbXML).toList();
    }

    public EbXMLRegistryError toEbXML(ErrorInfo errorInfo) {
        Objects.requireNonNull(errorInfo, "error info cannot be null");
        EbXMLRegistryError regError = this.factory.createRegistryError();
        regError.setErrorCode(errorInfo.getErrorCode() == ErrorCode._USER_DEFINED ? errorInfo.getCustomErrorCode() : ErrorCode.getOpcode(errorInfo.getErrorCode()));
        regError.setCodeContext(errorInfo.getCodeContext());
        regError.setSeverity(errorInfo.getSeverity());
        regError.setLocation(errorInfo.getLocation());
        return regError;
    }

    public ErrorInfo fromEbXML(EbXMLRegistryError ebXML) {
        ErrorInfo errorInfo = new ErrorInfo();
        ErrorCode errorCode = ErrorCode.valueOfOpcode(ebXML.getErrorCode());
        errorInfo.setErrorCode(errorCode);
        if (errorCode == ErrorCode._USER_DEFINED) {
            errorInfo.setCustomErrorCode(ebXML.getErrorCode());
        }
        errorInfo.setCodeContext(ebXML.getCodeContext());
        errorInfo.setLocation(ebXML.getLocation());
        errorInfo.setSeverity(ebXML.getSeverity());
        return errorInfo;
    }
}

