/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.validate;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLClassification;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLRegistryObject;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLSlot;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Vocabulary;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ClassificationValidation;
import org.openehealth.ipf.commons.ihe.xds.core.validate.SlotValueValidation;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationMessage;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidatorAssertions;
import org.openehealth.ipf.commons.ihe.xds.core.validate.XDSMetaDataException;

public class AuthorClassificationValidation
extends ClassificationValidation {
    private static final Set<String> SLOT_NAMES = new HashSet<String>();

    public AuthorClassificationValidation(String classScheme, SlotValueValidation[] slotValidations) {
        super(classScheme, 0, Integer.MAX_VALUE, Vocabulary.DisplayNameUsage.OPTIONAL, Vocabulary.NodeRepresentationUsage.PROHIBITED, slotValidations);
    }

    @Override
    public void validate(EbXMLRegistryObject obj) throws XDSMetaDataException {
        super.validate(obj);
        List<EbXMLClassification> classifications = obj.getClassifications(this.classScheme);
        for (EbXMLClassification classification : classifications) {
            boolean authorComplete = false;
            for (EbXMLSlot slot : classification.getSlots()) {
                if (!SLOT_NAMES.contains(slot.getName())) continue;
                authorComplete = true;
                break;
            }
            ValidatorAssertions.metaDataAssert(authorComplete, ValidationMessage.AUTHOR_INCOMPLETE, this.classScheme);
        }
    }

    static {
        SLOT_NAMES.add("authorPerson");
        SLOT_NAMES.add("authorTelecommunication");
        SLOT_NAMES.add("authorInstitution");
    }
}

