/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.validate;

import org.openehealth.ipf.commons.ihe.xds.core.validate.OIDValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationMessage;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidatorAssertions;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValueValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.XDSMetaDataException;

public class HomeCommunityIdValidator
implements ValueValidator {
    private final boolean required;

    public HomeCommunityIdValidator(boolean required) {
        this.required = required;
    }

    @Override
    public void validate(String homeCommunityId) throws XDSMetaDataException {
        if (this.required) {
            ValidatorAssertions.metaDataAssert(homeCommunityId != null && !homeCommunityId.isEmpty(), ValidationMessage.HOME_COMMUNITY_ID_MUST_BE_SPECIFIED, new Object[0]);
        }
        if (homeCommunityId != null) {
            ValidatorAssertions.metaDataAssert(homeCommunityId.startsWith("urn:oid:"), ValidationMessage.INVALID_OID, homeCommunityId);
            new OIDValidator().validate(homeCommunityId.substring(8));
        }
    }
}

