/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.validate;

import java.util.Objects;
import java.util.regex.Pattern;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationMessage;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidatorAssertions;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValueValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.XDSMetaDataException;

public class LanguageCodeValidator
implements ValueValidator {
    private static final Pattern CODE_PATTERN = Pattern.compile("[a-zA-Z]{1,8}(-[a-zA-Z0-9]{1,8})*");

    @Override
    public void validate(String value) throws XDSMetaDataException {
        Objects.requireNonNull(value, "value cannot be null");
        ValidatorAssertions.metaDataAssert(CODE_PATTERN.matcher(value).matches(), ValidationMessage.INVALID_LANGUAGE_CODE, value);
    }
}

