/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.validate;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationMessage;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidatorAssertions;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValueValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.XDSMetaDataException;

public class PidValidator
implements ValueValidator {
    private static final Pattern PID_PATTERN = Pattern.compile("\\s*PID-([1-9][0-9]*)\\|(.*)\\s*");

    @Override
    public void validate(String value) throws XDSMetaDataException {
        Objects.requireNonNull(value, "value cannot be null");
        Matcher matcher = PID_PATTERN.matcher(value);
        ValidatorAssertions.metaDataAssert(matcher.matches(), ValidationMessage.INVALID_PID, value);
        int number = Integer.parseInt(matcher.group(1));
        ValidatorAssertions.metaDataAssert(number != 2 && number != 4 && number != 12 && number != 19 && number <= 39, ValidationMessage.UNSUPPORTED_PID, value);
    }
}

