/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.validate;

import java.util.Objects;
import java.util.regex.Pattern;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationMessage;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidatorAssertions;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValueValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.XDSMetaDataException;

public class PositiveNumberValidator
implements ValueValidator {
    private static final Pattern NUMBER_PATTERN = Pattern.compile("[0-9]+");

    @Override
    public void validate(String value) throws XDSMetaDataException {
        Objects.requireNonNull(value, "value cannot be null");
        ValidatorAssertions.metaDataAssert(NUMBER_PATTERN.matcher(value).matches(), ValidationMessage.INVALID_NUMBER_FORMAT, value);
    }
}

