/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.validate;

import org.apache.commons.lang3.StringUtils;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLRegistryObject;
import org.openehealth.ipf.commons.ihe.xds.core.validate.RegistryObjectValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationMessage;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidatorAssertions;
import org.openehealth.ipf.commons.ihe.xds.core.validate.XDSMetaDataException;

public class ServiceTimeChronologyValidation
implements RegistryObjectValidator {
    @Override
    public void validate(EbXMLRegistryObject obj) throws XDSMetaDataException {
        String serviceStartTime = obj.getSingleSlotValue("serviceStartTime");
        String serviceStopTime = obj.getSingleSlotValue("serviceStopTime");
        if (serviceStartTime != null && serviceStopTime != null && !serviceStartTime.equals(serviceStopTime)) {
            ValidatorAssertions.metaDataAssert(this.fillToMaxLength(serviceStartTime, '0').compareTo(this.fillToMaxLength(serviceStopTime, '9')) <= 0, ValidationMessage.TIME_WRONG_CHRONOLOGY, serviceStartTime, serviceStopTime);
        }
    }

    private String fillToMaxLength(String timeValue, char fillCharacter) {
        return StringUtils.rightPad((String)timeValue, (int)14, (char)fillCharacter);
    }
}

