/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.validate;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.openehealth.ipf.commons.ihe.xds.core.XdsJaxbDataBinding;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLObjectContainer;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLRegistryObject;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLSlot;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLSlotList;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationMessage;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidatorAssertions;
import org.openehealth.ipf.commons.ihe.xds.core.validate.XDSMetaDataException;

public abstract class SlotLengthAndNameUniquenessValidator {
    public static void validateContainer(EbXMLObjectContainer container) throws XDSMetaDataException {
        SlotLengthAndNameUniquenessValidator.validateRegistryObjects(container.getAssociations());
        SlotLengthAndNameUniquenessValidator.validateRegistryObjects(container.getExtrinsicObjects());
        SlotLengthAndNameUniquenessValidator.validateRegistryObjects(container.getRegistryPackages());
        SlotLengthAndNameUniquenessValidator.validateSlotLists(container.getClassifications());
    }

    private static void validateRegistryObjects(List<? extends EbXMLRegistryObject> regObjects) throws XDSMetaDataException {
        SlotLengthAndNameUniquenessValidator.validateSlotLists(regObjects);
        for (EbXMLRegistryObject ebXMLRegistryObject : regObjects) {
            SlotLengthAndNameUniquenessValidator.validateSlotLists(ebXMLRegistryObject.getClassifications());
        }
    }

    private static void validateSlotLists(List<? extends EbXMLSlotList> slotListContainers) throws XDSMetaDataException {
        for (EbXMLSlotList ebXMLSlotList : slotListContainers) {
            SlotLengthAndNameUniquenessValidator.doValidateSlots(ebXMLSlotList.getSlots(), false, Collections.emptySet());
        }
    }

    public static void validateQuerySlots(List<? extends EbXMLSlot> slots, Set<String> allowedSlotNamesMultiple) throws XDSMetaDataException {
        SlotLengthAndNameUniquenessValidator.doValidateSlots(slots, true, allowedSlotNamesMultiple);
    }

    private static void doValidateSlots(List<? extends EbXMLSlot> slots, boolean queryMode, Set<String> allowedSlotNamesMultiple) throws XDSMetaDataException {
        HashSet<String> names = new HashSet<String>();
        for (EbXMLSlot ebXMLSlot : slots) {
            String name = ebXMLSlot.getName();
            ValidatorAssertions.metaDataAssert(StringUtils.isNotEmpty((CharSequence)name), ValidationMessage.MISSING_SLOT_NAME, new Object[0]);
            if (queryMode) {
                ValidatorAssertions.metaDataAssert(name.length() > 1 && name.charAt(0) == '$', ValidationMessage.WRONG_QUERY_SLOT_NAME, name);
                ValidatorAssertions.metaDataAssert(names.add(name) || allowedSlotNamesMultiple.contains(name) || XdsJaxbDataBinding.isExtraMetadataSlotName(name.substring(1)), ValidationMessage.DUPLICATE_SLOT_NAME, name);
            } else {
                ValidatorAssertions.metaDataAssert(names.add(name), ValidationMessage.DUPLICATE_SLOT_NAME, name);
            }
            ebXMLSlot.getValueList().stream().filter(Objects::nonNull).forEach(value -> ValidatorAssertions.metaDataAssert(value.length() <= slot.getValueLengthLimit(), ValidationMessage.SLOT_VALUE_TOO_LONG, name));
        }
    }
}

