/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.validate;

import ca.uhn.hl7v2.model.v25.datatype.HD;
import ca.uhn.hl7v2.model.v25.datatype.XCN;
import org.apache.commons.lang3.StringUtils;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Hl7v2Based;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Person;
import org.openehealth.ipf.commons.ihe.xds.core.validate.HDValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.HL7ValidationUtils;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationMessage;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidatorAssertions;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValueValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.XDSMetaDataException;

public class XCNValidator
implements ValueValidator {
    private static final HDValidator HD_VALIDATOR = new HDValidator();

    @Override
    public void validate(String hl7xcn) throws XDSMetaDataException {
        Person person = Hl7v2Based.parse(hl7xcn, Person.class);
        ValidatorAssertions.metaDataAssert(person != null, ValidationMessage.PERSON_MISSING_NAME_AND_ID, hl7xcn);
        XCN xcn = (XCN)person.getHapiObject();
        ValidatorAssertions.metaDataAssert(StringUtils.isNotEmpty((CharSequence)xcn.getXcn1_IDNumber().getValue()) || StringUtils.isNotEmpty((CharSequence)xcn.getXcn2_FamilyName().getFn1_Surname().getValue()), ValidationMessage.PERSON_MISSING_NAME_AND_ID, hl7xcn);
        HD hd = xcn.getXcn9_AssigningAuthority();
        if (HL7ValidationUtils.isNotEmptyField(hd)) {
            ValidatorAssertions.metaDataAssert(StringUtils.isNotEmpty((CharSequence)xcn.getXcn1_IDNumber().getValue()), ValidationMessage.PERSON_HD_INOPPORTUNE, hl7xcn);
            HD_VALIDATOR.validate(hd, hl7xcn);
        }
    }
}

