/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.validate.query;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.openehealth.ipf.commons.ihe.xds.core.XdsRuntimeException;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLAdhocQueryRequest;
import org.openehealth.ipf.commons.ihe.xds.core.responses.ErrorCode;
import org.openehealth.ipf.commons.ihe.xds.core.responses.Severity;
import org.openehealth.ipf.commons.ihe.xds.core.stub.ebrs30.query.AdhocQueryRequest;
import org.openehealth.ipf.commons.ihe.xds.core.transform.requests.QueryParameter;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationMessage;
import org.openehealth.ipf.commons.ihe.xds.core.validate.XDSMetaDataException;
import org.openehealth.ipf.commons.ihe.xds.core.validate.query.QueryParameterValidation;

public class ChoiceValidation
implements QueryParameterValidation {
    private final QueryParameter[] params;
    private final boolean optional;

    public ChoiceValidation(boolean optional, QueryParameter ... params) {
        this.params = Objects.requireNonNull(params, "params cannot be null");
        this.optional = optional;
    }

    @Override
    public void validate(EbXMLAdhocQueryRequest<AdhocQueryRequest> request) throws XDSMetaDataException {
        List<String> paramSlotNames = Arrays.stream(this.params).map(QueryParameter::getSlotName).toList();
        long count = paramSlotNames.stream().map(request::getSingleSlotValue).filter(Objects::nonNull).count();
        if (!this.optional && count == 0L) {
            throw new XDSMetaDataException(ValidationMessage.MISSING_REQUIRED_QUERY_PARAMETER, "one of " + paramSlotNames);
        }
        if (count > 1L) {
            throw new XdsRuntimeException(ErrorCode.STORED_QUERY_PARAM_NUMBER, String.format(ValidationMessage.QUERY_PARAMETERS_CANNOT_BE_SET_TOGETHER.getText(), paramSlotNames), Severity.ERROR, null);
        }
    }
}

