/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.validate.requests;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.openehealth.ipf.commons.core.modules.api.Validator;
import org.openehealth.ipf.commons.ihe.xds.CONTINUA_HRN;
import org.openehealth.ipf.commons.ihe.xds.RMU;
import org.openehealth.ipf.commons.ihe.xds.XCDR;
import org.openehealth.ipf.commons.ihe.xds.XCF;
import org.openehealth.ipf.commons.ihe.xds.XDM;
import org.openehealth.ipf.commons.ihe.xds.XDR;
import org.openehealth.ipf.commons.ihe.xds.XDS;
import org.openehealth.ipf.commons.ihe.xds.core.XdsRuntimeException;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLAssociation;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLExtrinsicObject;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLObjectContainer;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLRegistryObject;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLRegistryPackage;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.AssociationLabel;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.AssociationType;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.AvailabilityStatus;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.DocumentEntryType;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.LocalizedString;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Vocabulary;
import org.openehealth.ipf.commons.ihe.xds.core.responses.ErrorCode;
import org.openehealth.ipf.commons.ihe.xds.core.responses.Severity;
import org.openehealth.ipf.commons.ihe.xds.core.validate.AuthorClassificationValidation;
import org.openehealth.ipf.commons.ihe.xds.core.validate.CXValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.CXiValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ClassificationValidation;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ExternalIdentifierValidation;
import org.openehealth.ipf.commons.ihe.xds.core.validate.HashValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.IdentifierValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.LanguageCodeValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.MimeTypeValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.NopValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.OIDValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.PidValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.PositiveNumberValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.RecipientListValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.RegistryObjectValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ServiceTimeChronologyValidation;
import org.openehealth.ipf.commons.ihe.xds.core.validate.SlotLengthAndNameUniquenessValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.SlotValidation;
import org.openehealth.ipf.commons.ihe.xds.core.validate.SlotValueValidation;
import org.openehealth.ipf.commons.ihe.xds.core.validate.TimeValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.UUIDValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.UriValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationMessage;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationProfile;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidatorAssertions;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValueValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.XCNValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.XDSMetaDataException;
import org.openehealth.ipf.commons.ihe.xds.core.validate.XONValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.XTNValidator;

public class ObjectContainerValidator
implements Validator<EbXMLObjectContainer, ValidationProfile> {
    private final OIDValidator oidValidator = new OIDValidator();
    private final TimeValidator timeValidator = new TimeValidator();
    private final TimeValidator timeValidatorSec = new TimeValidator(14);
    private final XCNValidator xcnValidator = new XCNValidator();
    private final XONValidator xonValidator = new XONValidator();
    private final HashValidator hashValidator = new HashValidator();
    private final NopValidator nopValidator = new NopValidator();
    private final LanguageCodeValidator languageCodeValidator = new LanguageCodeValidator();
    private final PositiveNumberValidator positiveNumberValidator = new PositiveNumberValidator();
    private final PidValidator pidValidator = new PidValidator();
    private final UriValidator uriValidator = new UriValidator();
    private final RecipientListValidator recipientListValidator = new RecipientListValidator();
    private final CXValidator cxValidatorRequiredAA = new CXValidator(true);
    private final CXValidator cxValidatorOptionalAA = new CXValidator(false);
    private final XTNValidator xtnValidator = new XTNValidator();
    private final CXiValidator cxiValidator = new CXiValidator();
    private final UUIDValidator uuidValidator = new UUIDValidator();
    private final IdentifierValidator identifierValidator = new IdentifierValidator();
    private final MimeTypeValidator mimeTypeValidator = new MimeTypeValidator();
    private final SlotValueValidation[] authorValidations = new SlotValueValidation[]{new SlotValueValidation("authorPerson", this.xcnValidator, 0, 1), new SlotValueValidation("authorInstitution", this.xonValidator, 0, Integer.MAX_VALUE), new SlotValueValidation("authorRole", this.cxValidatorOptionalAA, 0, Integer.MAX_VALUE), new SlotValueValidation("authorSpecialty", this.cxValidatorOptionalAA, 0, Integer.MAX_VALUE), new SlotValueValidation("authorTelecommunication", this.xtnValidator, 0, Integer.MAX_VALUE)};
    private final SlotValueValidation[] codingSchemeValidations = new SlotValueValidation[]{new SlotValueValidation("codingScheme", this.nopValidator)};
    private static final ObjectContainerValidator instance = new ObjectContainerValidator();

    private ObjectContainerValidator() {
    }

    private List<RegistryObjectValidator> documentEntrySlotValidators(ValidationProfile profile, boolean onDemandProvided, boolean limitedMetadata) {
        boolean isContinuaHRN = profile == CONTINUA_HRN.Interactions.ITI_41;
        Vocabulary.DisplayNameUsage requiredOnlyForContinuaHRN = isContinuaHRN ? Vocabulary.DisplayNameUsage.REQUIRED : Vocabulary.DisplayNameUsage.OPTIONAL;
        boolean isOnDemand = profile == XDS.Interactions.ITI_61 || profile.isQuery() && onDemandProvided;
        boolean needHashAndSize = !isOnDemand && (isContinuaHRN || profile.isQuery() || profile == XDS.Interactions.ITI_42 || profile == XDM.Interactions.ITI_41);
        boolean needPatientId = !limitedMetadata && profile != XCDR.Interactions.ITI_80;
        boolean needRepositoryUniqueId = profile.getInteractionId() == XDS.Interactions.ITI_42 || isOnDemand || profile.isQuery();
        ArrayList<RegistryObjectValidator> validators = new ArrayList<RegistryObjectValidator>();
        Collections.addAll(validators, new SlotValueValidation("creationTime", this.timeValidator, limitedMetadata || isOnDemand ? 0 : 1, isOnDemand ? 0 : 1), new SlotValueValidation("serviceStartTime", this.timeValidator, 0, 1), new SlotValueValidation("serviceStopTime", this.timeValidator, 0, 1), new ServiceTimeChronologyValidation(), new SlotValueValidation("hash", this.hashValidator, needHashAndSize ? 1 : 0, isOnDemand ? 0 : 1), new SlotValueValidation("languageCode", this.languageCodeValidator, limitedMetadata ? 0 : 1, 1), new SlotValueValidation("legalAuthenticator", this.xcnValidator, 0, isOnDemand || isContinuaHRN ? 0 : 1), new SlotValueValidation("size", this.positiveNumberValidator, needHashAndSize ? 1 : 0, isOnDemand ? 0 : 1), new SlotValueValidation("sourcePatientId", this.cxValidatorRequiredAA, profile.isEbXml30Based() && !limitedMetadata ? 1 : 0, 1), new SlotValueValidation("sourcePatientInfo", this.pidValidator, isContinuaHRN ? 1 : 0, Integer.MAX_VALUE), new SlotValueValidation("urn:ihe:iti:xds:2013:referenceIdList", this.cxiValidator, 0, Integer.MAX_VALUE), new SlotValueValidation("URI", this.uriValidator, 0, 1), new AuthorClassificationValidation("urn:uuid:93606bcf-9494-43ec-9b4e-a7748d1a838d", this.authorValidations), new ClassificationValidation("urn:uuid:41a5887f-8865-4c09-adf7-e362475b143a", limitedMetadata ? 0 : 1, 1, requiredOnlyForContinuaHRN, this.codingSchemeValidations), new ClassificationValidation("urn:uuid:f4f85eac-e6cb-4883-b524-f2705394840f", limitedMetadata ? 0 : 1, Integer.MAX_VALUE, requiredOnlyForContinuaHRN, this.codingSchemeValidations), new ClassificationValidation("urn:uuid:2c6b8cb7-8b2a-4051-b291-b1ae6a575ef4", 0, Integer.MAX_VALUE, requiredOnlyForContinuaHRN, this.codingSchemeValidations), new ClassificationValidation("urn:uuid:a09d5840-386c-46f2-b5ad-9c3699a4309d", limitedMetadata ? 0 : 1, 1, Vocabulary.DisplayNameUsage.OPTIONAL, this.codingSchemeValidations), new ClassificationValidation("urn:uuid:f33fb8ac-18af-42cc-ae0e-ed0b0bdb91e1", limitedMetadata ? 0 : 1, 1, requiredOnlyForContinuaHRN, this.codingSchemeValidations), new ClassificationValidation("urn:uuid:cccf5598-8b07-4b77-a05e-ae952c785ead", limitedMetadata ? 0 : 1, 1, requiredOnlyForContinuaHRN, this.codingSchemeValidations), new ClassificationValidation("urn:uuid:f0306f51-975f-434e-a61c-c59651d33983", limitedMetadata ? 0 : 1, 1, requiredOnlyForContinuaHRN, this.codingSchemeValidations), new ExternalIdentifierValidation("urn:uuid:58a6f841-87b3-4a3e-92fd-a8ffeff98427", this.cxValidatorRequiredAA, needPatientId), new SlotValueValidation("repositoryUniqueId", this.oidValidator, needRepositoryUniqueId ? 1 : 0, 1));
        return validators;
    }

    private List<RegistryObjectValidator> getSubmissionSetSlotValidations(ValidationProfile profile, boolean limitedMetadata) {
        boolean isContinuaHRN = profile == CONTINUA_HRN.Interactions.ITI_41;
        Vocabulary.DisplayNameUsage requiredOnlyForContinuaHRN = isContinuaHRN ? Vocabulary.DisplayNameUsage.REQUIRED : Vocabulary.DisplayNameUsage.OPTIONAL;
        boolean needPatientId = !limitedMetadata && profile != XCDR.Interactions.ITI_80;
        ArrayList<RegistryObjectValidator> validators = new ArrayList<RegistryObjectValidator>();
        Collections.addAll(validators, new SlotValidation("intendedRecipient", this.recipientListValidator), new SlotValueValidation("submissionTime", this.timeValidator), new AuthorClassificationValidation("urn:uuid:a7058bb9-b4e4-4307-ba5b-e3f0ab85e12d", this.authorValidations), new ClassificationValidation("urn:uuid:aa543740-bdda-424e-8c96-df4873be8500", limitedMetadata ? 0 : 1, 1, requiredOnlyForContinuaHRN, this.codingSchemeValidations), new ExternalIdentifierValidation("urn:uuid:554ac39e-e3fe-47fe-b233-965d2a147832", this.oidValidator, true), new ExternalIdentifierValidation("urn:uuid:6b5aea1a-874d-4603-a4bc-96a0a7b38446", this.cxValidatorRequiredAA, needPatientId));
        return validators;
    }

    private List<RegistryObjectValidator> getFolderSlotValidations(ValidationProfile profile, boolean limitedMetadata) {
        boolean needPatientId = !limitedMetadata && profile != XCDR.Interactions.ITI_80;
        ArrayList<RegistryObjectValidator> validators = new ArrayList<RegistryObjectValidator>();
        Collections.addAll(validators, new SlotValueValidation("lastUpdateTime", this.timeValidatorSec, 0, 1), new ClassificationValidation("urn:uuid:1ba97051-7806-41a8-a48b-8fce7af683c5", limitedMetadata ? 0 : 1, Integer.MAX_VALUE, Vocabulary.DisplayNameUsage.OPTIONAL, this.codingSchemeValidations), new ExternalIdentifierValidation("urn:uuid:f64ffdf0-4b97-4e06-b79f-a52b38ec2f8a", this.cxValidatorRequiredAA, needPatientId));
        return validators;
    }

    private boolean checkLimitedMetadata(EbXMLRegistryObject object, String limitedMetadataClassNode, ValidationProfile profile) {
        boolean limitedMetadata = object.getClassifications().stream().anyMatch(cl -> limitedMetadataClassNode.equals(cl.getClassificationNode()));
        if (limitedMetadata) {
            ValidatorAssertions.metaDataAssert(profile == XDM.Interactions.ITI_41 || profile == XDR.Interactions.ITI_41, ValidationMessage.LIMITED_METADATA_PROHIBITED, object.getId());
        } else {
            ValidatorAssertions.metaDataAssert(profile != XDR.Interactions.ITI_41, ValidationMessage.LIMITED_METADATA_REQUIRED, object.getId());
        }
        return limitedMetadata;
    }

    public void validate(EbXMLObjectContainer container, ValidationProfile profile) {
        Objects.requireNonNull(container, "container cannot be null");
        Objects.requireNonNull(profile, "profile must be set");
        SlotLengthAndNameUniquenessValidator.validateContainer(container);
        this.validateSubmissionSet(container, profile);
        if (!profile.isQuery()) {
            this.validateUniquenessOfUUIDs(container);
            this.validateUniqueIds(container, profile);
        }
        this.validateAssociations(container, profile);
        this.validateDocumentEntries(container, profile);
        this.validateFolders(container, profile);
        if (!profile.isQuery()) {
            this.validatePatientIdsAreIdentical(container);
        }
    }

    private void validateFolders(EbXMLObjectContainer container, ValidationProfile profile) throws XDSMetaDataException {
        HashSet<String> logicalIds = new HashSet<String>();
        for (EbXMLRegistryPackage folder : container.getRegistryPackages("urn:uuid:d9d542f3-6cc4-48b6-8870-ea235fbc94c2")) {
            if (profile == RMU.Interactions.ITI_92) {
                throw new XdsRuntimeException(ErrorCode.OBJECT_TYPE_ERROR, "Folders cannot be updated", Severity.ERROR, folder.getId());
            }
            boolean limitedMetadata = this.checkLimitedMetadata(folder, "urn:uuid:2c144a76-29a9-4b7c-af54-b25409fe7d03", profile);
            this.runValidations(folder, this.getFolderSlotValidations(profile, limitedMetadata));
            AvailabilityStatus status = folder.getStatus();
            if (profile.isQuery() || status != null) {
                ValidatorAssertions.metaDataAssert(status == AvailabilityStatus.APPROVED, ValidationMessage.FOLDER_INVALID_AVAILABILITY_STATUS, new Object[]{status});
            }
            ValidatorAssertions.metaDataAssert(StringUtils.isBlank((CharSequence)folder.getLid()) || logicalIds.add(folder.getLid()), ValidationMessage.LOGICAL_ID_SAME, folder.getLid());
            LocalizedString name = folder.getName();
            ValidatorAssertions.metaDataAssert(limitedMetadata || name != null && name.getValue() != null, ValidationMessage.MISSING_FOLDER_NAME, folder.getId());
            if (profile != XDS.Interactions.ITI_57) continue;
            this.validateUpdateObject(folder, container, profile);
        }
    }

    private void validateSubmissionSet(EbXMLObjectContainer container, ValidationProfile profile) throws XDSMetaDataException {
        List<EbXMLRegistryPackage> submissionSets = container.getRegistryPackages("urn:uuid:a54d6aa5-d40d-43f9-88c5-b4633d873bdd");
        if (!profile.isQuery()) {
            ValidatorAssertions.metaDataAssert(submissionSets.size() == 1, ValidationMessage.EXACTLY_ONE_SUBMISSION_SET_MUST_EXIST, new Object[0]);
        }
        for (EbXMLRegistryPackage submissionSet : submissionSets) {
            boolean limitedMetadata = this.checkLimitedMetadata(submissionSet, "urn:uuid:5003a9db-8d8d-49e6-bf0c-990e34ac7707", profile);
            this.runValidations(submissionSet, this.getSubmissionSetSlotValidations(profile, limitedMetadata));
            AvailabilityStatus status = submissionSet.getStatus();
            if (!profile.isQuery() && status == null) continue;
            ValidatorAssertions.metaDataAssert(status == AvailabilityStatus.APPROVED, ValidationMessage.SUBMISSION_SET_INVALID_AVAILABILITY_STATUS, new Object[]{status});
        }
    }

    private void validateDocumentEntries(EbXMLObjectContainer container, ValidationProfile profile) throws XDSMetaDataException {
        HashSet<String> logicalIds = new HashSet<String>();
        for (EbXMLExtrinsicObject docEntry : container.getExtrinsicObjects(DocumentEntryType.STABLE_OR_ON_DEMAND)) {
            LocalizedString name;
            boolean limitedMetadata = this.checkLimitedMetadata(docEntry, "urn:uuid:ab9b591b-83ab-4d03-8f5d-f93b1fb92e85", profile);
            boolean onDemandProvided = DocumentEntryType.ON_DEMAND.getUuid().equals(docEntry.getObjectType());
            if (onDemandProvided) {
                ValidatorAssertions.metaDataAssert(profile == XDS.Interactions.ITI_61 || profile == RMU.Interactions.ITI_92 || profile.isQuery(), ValidationMessage.WRONG_DOCUMENT_ENTRY_TYPE, docEntry.getObjectType());
            } else {
                ValidatorAssertions.metaDataAssert(profile != XDS.Interactions.ITI_61, ValidationMessage.WRONG_DOCUMENT_ENTRY_TYPE, docEntry.getObjectType());
            }
            this.runValidations(docEntry, this.documentEntrySlotValidators(profile, onDemandProvided, limitedMetadata));
            if (profile.isQuery()) {
                AvailabilityStatus status = docEntry.getStatus();
                ValidatorAssertions.metaDataAssert(status == AvailabilityStatus.APPROVED || status == AvailabilityStatus.DEPRECATED, ValidationMessage.DOC_ENTRY_INVALID_AVAILABILITY_STATUS, new Object[]{status});
            }
            if ((name = docEntry.getName()) != null && name.getValue() != null) {
                ValidatorAssertions.metaDataAssert("UTF8".equals(name.getCharset()) || "UTF-8".equals(name.getCharset()), ValidationMessage.INVALID_TITLE_ENCODING, name.getCharset());
                ValidatorAssertions.metaDataAssert(name.getValue().length() <= 128, ValidationMessage.TITLE_TOO_LONG, name.getValue());
            }
            boolean attachmentExpected = profile.getInteractionId() == XCF.Interactions.ITI_63;
            boolean attachmentProvided = docEntry.getDataHandler() != null;
            ValidatorAssertions.metaDataAssert(attachmentProvided == attachmentExpected, attachmentExpected ? ValidationMessage.MISSING_DOCUMENT_FOR_DOC_ENTRY : ValidationMessage.DOCUMENT_NOT_ALLOWED_IN_DOC_ENTRY, docEntry.getId());
            ValidatorAssertions.metaDataAssert(profile.isQuery() || StringUtils.isBlank((CharSequence)docEntry.getLid()) || logicalIds.add(docEntry.getLid()), ValidationMessage.LOGICAL_ID_SAME, docEntry.getLid());
            String mimeType = docEntry.getMimeType();
            ValidatorAssertions.metaDataAssert(StringUtils.isNotEmpty((CharSequence)mimeType), ValidationMessage.MIME_TYPE_MUST_BE_SPECIFIED, new Object[0]);
            this.mimeTypeValidator.validate(mimeType);
            if (profile != XDS.Interactions.ITI_57 && profile != RMU.Interactions.ITI_92) continue;
            this.validateUpdateObject(docEntry, container, profile);
        }
    }

    private void runValidations(EbXMLRegistryObject obj, List<RegistryObjectValidator> validations) throws XDSMetaDataException {
        for (RegistryObjectValidator validation : validations) {
            validation.validate(obj);
        }
    }

    private void validateUniqueIds(EbXMLObjectContainer container, ValidationProfile profile) throws XDSMetaDataException {
        HashSet idsInRequest = new HashSet();
        ValidationMessage validationMsg = profile == XDS.Interactions.ITI_41 ? ValidationMessage.UNIQUE_ID_NOT_UNIQUE_REPO : ValidationMessage.UNIQUE_ID_NOT_UNIQUE;
        ValueValidator uniquenessValidator = uniqueId -> ValidatorAssertions.metaDataAssert(idsInRequest.add(uniqueId), validationMsg, uniqueId);
        this.validateUniqueIds(container.getExtrinsicObjects(DocumentEntryType.STABLE_OR_ON_DEMAND), "urn:uuid:2e82c1f6-a085-4c72-9da3-8640a32e42ab", uniquenessValidator, this.identifierValidator);
        this.validateUniqueIds(container.getRegistryPackages("urn:uuid:d9d542f3-6cc4-48b6-8870-ea235fbc94c2"), "urn:uuid:75df8f67-9973-4fbe-a900-df66cefecc5a", uniquenessValidator, this.oidValidator);
        this.validateUniqueIds(container.getRegistryPackages("urn:uuid:a54d6aa5-d40d-43f9-88c5-b4633d873bdd"), "urn:uuid:96fdda7c-d067-4183-912e-bf5ee74998a8", uniquenessValidator, this.oidValidator);
    }

    private void validateUniqueIds(List<? extends EbXMLRegistryObject> objects, String scheme, ValueValidator uniquenessValidator, ValueValidator formatValidator) throws XDSMetaDataException {
        for (EbXMLRegistryObject ebXMLRegistryObject : objects) {
            String uniqueId = ebXMLRegistryObject.getExternalIdentifierValue(scheme);
            ValidatorAssertions.metaDataAssert(uniqueId != null, ValidationMessage.UNIQUE_ID_MISSING, new Object[0]);
            ValidatorAssertions.metaDataAssert(uniqueId.length() <= 128, ValidationMessage.UNIQUE_ID_TOO_LONG, new Object[0]);
            uniquenessValidator.validate(uniqueId);
            formatValidator.validate(uniqueId);
        }
    }

    private void validateUniquenessOfUUIDs(EbXMLObjectContainer container) throws XDSMetaDataException {
        HashSet<String> uuids = new HashSet<String>();
        this.addUUIDs(container.getAssociations(), uuids);
        this.addUUIDs(container.getExtrinsicObjects(), uuids);
        this.addUUIDs(container.getRegistryPackages(), uuids);
    }

    private void addUUIDs(List<? extends EbXMLRegistryObject> objects, Set<String> uuids) throws XDSMetaDataException {
        for (EbXMLRegistryObject ebXMLRegistryObject : objects) {
            String uuid = ebXMLRegistryObject.getId();
            if (uuid == null) continue;
            ValidatorAssertions.metaDataAssert(uuids.add(uuid), ValidationMessage.UUID_NOT_UNIQUE, new Object[0]);
        }
    }

    private void validatePatientIdsAreIdentical(EbXMLObjectContainer container) throws XDSMetaDataException {
        List<EbXMLRegistryPackage> submissionSets = container.getRegistryPackages("urn:uuid:a54d6aa5-d40d-43f9-88c5-b4633d873bdd");
        EbXMLRegistryPackage submissionSet = submissionSets.get(0);
        String patientId = submissionSet.getExternalIdentifierValue("urn:uuid:6b5aea1a-874d-4603-a4bc-96a0a7b38446");
        for (EbXMLExtrinsicObject docEntry : container.getExtrinsicObjects(DocumentEntryType.STABLE_OR_ON_DEMAND)) {
            String patientIdDocEntry = docEntry.getExternalIdentifierValue("urn:uuid:58a6f841-87b3-4a3e-92fd-a8ffeff98427");
            ValidatorAssertions.metaDataAssert(StringUtils.equals((CharSequence)patientId, (CharSequence)patientIdDocEntry), ValidationMessage.DOC_ENTRY_PATIENT_ID_WRONG, new Object[0]);
        }
        for (EbXMLRegistryPackage folder : container.getRegistryPackages("urn:uuid:d9d542f3-6cc4-48b6-8870-ea235fbc94c2")) {
            String patientIdFolder = folder.getExternalIdentifierValue("urn:uuid:f64ffdf0-4b97-4e06-b79f-a52b38ec2f8a");
            ValidatorAssertions.metaDataAssert(StringUtils.equals((CharSequence)patientId, (CharSequence)patientIdFolder), ValidationMessage.FOLDER_PATIENT_ID_WRONG, new Object[0]);
        }
    }

    private void validateAssociations(EbXMLObjectContainer container, ValidationProfile profile) throws XDSMetaDataException {
        HashSet<String> logicalIds = new HashSet<String>();
        Set<String> docEntryIds = container.getExtrinsicObjects(DocumentEntryType.STABLE_OR_ON_DEMAND).stream().map(EbXMLRegistryObject::getId).filter(Objects::nonNull).collect(Collectors.toSet());
        Set submissionSetIds = container.getRegistryPackages("urn:uuid:a54d6aa5-d40d-43f9-88c5-b4633d873bdd").stream().map(EbXMLRegistryObject::getId).collect(Collectors.toSet());
        HashSet<String> associationIds = new HashSet<String>();
        boolean hasSubmitAssociationType = false;
        for (EbXMLAssociation association : container.getAssociations()) {
            associationIds.add(association.getId());
            AssociationType type = association.getAssociationType();
            ValidatorAssertions.metaDataAssert(type != null, ValidationMessage.INVALID_ASSOCIATION_TYPE, new Object[0]);
            hasSubmitAssociationType = hasSubmitAssociationType || type == AssociationType.SUBMIT_ASSOCIATION || type == AssociationType.UPDATE_AVAILABILITY_STATUS;
            ValidatorAssertions.metaDataAssert(StringUtils.isBlank((CharSequence)association.getLid()) || logicalIds.add(association.getLid()), ValidationMessage.LOGICAL_ID_SAME, association.getLid());
        }
        block8: for (EbXMLAssociation association : container.getAssociations()) {
            switch (association.getAssociationType()) {
                case HAS_MEMBER: {
                    boolean isSubmissionSetToDocEntry = submissionSetIds.contains(association.getSource()) && docEntryIds.contains(association.getTarget());
                    this.validateAssociation(association, docEntryIds, profile, isSubmissionSetToDocEntry);
                    continue block8;
                }
                case IS_SNAPSHOT_OF: {
                    if (profile.isQuery()) continue block8;
                    EbXMLExtrinsicObject sourceDocEntry = this.getExtrinsicObject(container, association.getSource(), DocumentEntryType.STABLE.getUuid());
                    ValidatorAssertions.metaDataAssert(sourceDocEntry != null, ValidationMessage.MISSING_SNAPSHOT_ASSOCIATION, "sourceObject", association.getSource());
                    ValidatorAssertions.metaDataAssert(hasSubmitAssociationType || docEntryIds.contains(association.getSource()), ValidationMessage.SOURCE_UUID_NOT_FOUND, new Object[0]);
                    continue block8;
                }
                case UPDATE_AVAILABILITY_STATUS: {
                    if (profile.isQuery()) continue block8;
                    ValidatorAssertions.metaDataAssert(submissionSetIds.contains(association.getSource()), ValidationMessage.MISSING_SUBMISSION_SET, association.getSource());
                    ValidatorAssertions.metaDataAssert(association.getOriginalStatus() != null, ValidationMessage.MISSING_ORIGINAL_STATUS, new Object[0]);
                    ValidatorAssertions.metaDataAssert(association.getNewStatus() != null, ValidationMessage.MISSING_NEW_STATUS, new Object[0]);
                    continue block8;
                }
                case SUBMIT_ASSOCIATION: {
                    if (profile.isQuery()) continue block8;
                    ValidatorAssertions.metaDataAssert(submissionSetIds.contains(association.getSource()), ValidationMessage.MISSING_SUBMISSION_SET, association.getSource());
                    ValidatorAssertions.metaDataAssert(associationIds.contains(association.getTarget()), ValidationMessage.MISSING_ASSOCIATION, association.getTarget());
                    continue block8;
                }
                case NON_VERSIONING_UPDATE: {
                    ValidatorAssertions.metaDataAssert(profile.getInteractionId().equals(XDS.Interactions.ITI_18) || profile.getInteractionId().equals(XDS.Interactions.ITI_57), ValidationMessage.INVALID_ASSOCIATION_TYPE, association.getSource());
                    continue block8;
                }
            }
            ValidatorAssertions.metaDataAssert(profile.isQuery() || hasSubmitAssociationType || docEntryIds.contains(association.getSource()), ValidationMessage.SOURCE_UUID_NOT_FOUND, new Object[0]);
        }
    }

    private void validateAssociation(EbXMLAssociation association, Set<String> docEntryIds, ValidationProfile profile, boolean isSubmissionSetToDocEntry) throws XDSMetaDataException {
        ValidatorAssertions.metaDataAssert(association.getSingleClassification("urn:uuid:abd807a3-4432-4053-87b4-fd82c643d1f3") == null, ValidationMessage.DOC_CODE_NOT_ALLOWED_ON_HAS_MEMBER, new Object[0]);
        List<String> slotValues = association.getSlotValues("SubmissionSetStatus");
        if (isSubmissionSetToDocEntry) {
            ValidatorAssertions.metaDataAssert(!slotValues.isEmpty(), ValidationMessage.SUBMISSION_SET_STATUS_MANDATORY, new Object[0]);
        }
        if (!slotValues.isEmpty()) {
            ValidatorAssertions.metaDataAssert(slotValues.size() == 1, ValidationMessage.TOO_MANY_SUBMISSION_SET_STATES, new Object[0]);
            AssociationLabel status = AssociationLabel.fromOpcode(slotValues.get(0));
            if (status == AssociationLabel.ORIGINAL && !profile.isQuery()) {
                ValidatorAssertions.metaDataAssert(docEntryIds.contains(association.getTarget()), ValidationMessage.MISSING_ORIGINAL, new Object[0]);
            }
        }
    }

    private EbXMLExtrinsicObject getExtrinsicObject(EbXMLObjectContainer container, String docEntryId, String ... objectTypes) {
        for (EbXMLExtrinsicObject docEntry : container.getExtrinsicObjects(objectTypes)) {
            if (docEntry.getId() == null || !docEntry.getId().equals(docEntryId)) continue;
            return docEntry;
        }
        return null;
    }

    private EbXMLRegistryPackage getRegistryPackage(EbXMLObjectContainer container, String submissionSetId, String classificationNode) {
        for (EbXMLRegistryPackage registryPackage : container.getRegistryPackages(classificationNode)) {
            if (registryPackage.getId() == null || !registryPackage.getId().equals(submissionSetId)) continue;
            return registryPackage;
        }
        return null;
    }

    private void validateUpdateObject(EbXMLRegistryObject registryObject, EbXMLObjectContainer container, ValidationProfile profile) {
        String logicalId = registryObject.getLid();
        if (logicalId != null) {
            this.uuidValidator.validate(logicalId);
            if (logicalId.equals(registryObject.getId())) {
                throw new XdsRuntimeException(ErrorCode.INVALID_REQUEST_EXCEPTION, "Initial version of the object was received in an update transaction", Severity.ERROR, registryObject.getId());
            }
        } else if (profile == XDS.Interactions.ITI_57) {
            throw new XdsRuntimeException(ErrorCode.METADATA_UPDATE_ERROR, "logical ID is missing in the XDS Metadata Update request", Severity.ERROR, registryObject.getId());
        }
        boolean foundHasMemberAssociation = false;
        for (EbXMLAssociation association : container.getAssociations()) {
            if (association.getAssociationType() != AssociationType.HAS_MEMBER || !association.getTarget().equals(registryObject.getId()) || this.getRegistryPackage(container, association.getSource(), "urn:uuid:a54d6aa5-d40d-43f9-88c5-b4633d873bdd") == null) continue;
            if (association.getPreviousVersion() == null) {
                throw new XdsRuntimeException(ErrorCode.METADATA_VERSION_ERROR, "previous version is missing in the SS-DE HasMember association", Severity.ERROR, association.getId());
            }
            if (profile == RMU.Interactions.ITI_92 && Boolean.FALSE.equals(association.getAssociationPropagation())) {
                throw new XdsRuntimeException(ErrorCode.METADATA_ANNOTATION_ERROR, "association propagation shall be not disabled in the SS-DE HasMember association", Severity.ERROR, association.getId());
            }
            foundHasMemberAssociation = true;
        }
        if (!foundHasMemberAssociation) {
            throw new XdsRuntimeException(ErrorCode.METADATA_ANNOTATION_ERROR, "SS-DE HasMember association is missing", Severity.ERROR, registryObject.getId());
        }
    }

    @Generated
    public static ObjectContainerValidator getInstance() {
        return instance;
    }
}

