/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.validate.requests;

import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.openehealth.ipf.commons.core.modules.api.Validator;
import org.openehealth.ipf.commons.ihe.xds.XdsIntegrationProfile;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLRetrieveImagingDocumentSetRequest;
import org.openehealth.ipf.commons.ihe.xds.core.stub.xdsi.RetrieveImagingDocumentSetRequestType;
import org.openehealth.ipf.commons.ihe.xds.core.validate.HomeCommunityIdValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationMessage;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationProfile;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidatorAssertions;

public class RetrieveImagingDocumentSetRequestValidator
implements Validator<EbXMLRetrieveImagingDocumentSetRequest<RetrieveImagingDocumentSetRequestType>, ValidationProfile> {
    private final HomeCommunityIdValidator hcValidator = new HomeCommunityIdValidator(true);
    private static final RetrieveImagingDocumentSetRequestValidator instance = new RetrieveImagingDocumentSetRequestValidator();

    private RetrieveImagingDocumentSetRequestValidator() {
    }

    public void validate(EbXMLRetrieveImagingDocumentSetRequest<RetrieveImagingDocumentSetRequestType> request, ValidationProfile profile) {
        Objects.requireNonNull(request, "request cannot be null");
        request.getRetrieveStudies().forEach(retrieveStudy -> {
            String studyInstanceUID = retrieveStudy.getStudyInstanceUID();
            ValidatorAssertions.metaDataAssert(StringUtils.isNotEmpty((CharSequence)studyInstanceUID), ValidationMessage.STUDY_INSTANCE_UID_MUST_BE_SPECIFIED, new Object[0]);
            List<String> transferSyntaxUIDList = request.getTransferSyntaxUIDList();
            ValidatorAssertions.metaDataAssert(transferSyntaxUIDList != null && !transferSyntaxUIDList.isEmpty(), ValidationMessage.TRANSFER_SYNTAX_UID_LIST_MUST_BE_SPECIFIED, new Object[0]);
            retrieveStudy.getRetrieveSerieses().forEach(retrieveSeries -> {
                String seriesInstanceUID = retrieveSeries.getSeriesInstanceUID();
                ValidatorAssertions.metaDataAssert(StringUtils.isNotEmpty((CharSequence)seriesInstanceUID), ValidationMessage.SERIES_INSTANCE_UID_MUST_BE_SPECIFIED, new Object[0]);
                retrieveSeries.getDocuments().forEach(document -> {
                    String repoId = document.getRepositoryUniqueId();
                    ValidatorAssertions.metaDataAssert(StringUtils.isNotEmpty((CharSequence)repoId), ValidationMessage.REPO_ID_MUST_BE_SPECIFIED, new Object[0]);
                    String docId = document.getDocumentUniqueId();
                    ValidatorAssertions.metaDataAssert(StringUtils.isNotEmpty((CharSequence)docId), ValidationMessage.DOC_ID_MUST_BE_SPECIFIED, new Object[0]);
                    if (profile.getInteractionProfile().getHomeCommunityIdOptionality() != XdsIntegrationProfile.HomeCommunityIdOptionality.NEVER) {
                        this.hcValidator.validate(document.getHomeCommunityId());
                    }
                });
            });
        });
    }

    @Generated
    public static RetrieveImagingDocumentSetRequestValidator getInstance() {
        return instance;
    }
}

