/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.validate.requests;

import lombok.Generated;
import org.openehealth.ipf.commons.core.modules.api.Validator;
import org.openehealth.ipf.commons.ihe.xds.XCDR;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLSubmitObjectsRequest;
import org.openehealth.ipf.commons.ihe.xds.core.validate.HomeCommunityIdValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationProfile;
import org.openehealth.ipf.commons.ihe.xds.core.validate.requests.ObjectContainerValidator;

public class SubmitObjectsRequestValidator
implements Validator<EbXMLSubmitObjectsRequest<?>, ValidationProfile> {
    private static final ObjectContainerValidator OBJECT_CONTAINER_VALIDATOR = ObjectContainerValidator.getInstance();
    private static final HomeCommunityIdValidator HOME_COMMUNITY_ID_VALIDATOR = new HomeCommunityIdValidator(false);
    private static final SubmitObjectsRequestValidator instance = new SubmitObjectsRequestValidator();

    private SubmitObjectsRequestValidator() {
    }

    public void validate(EbXMLSubmitObjectsRequest<?> request, ValidationProfile profile) {
        OBJECT_CONTAINER_VALIDATOR.validate(request, profile);
        HOME_COMMUNITY_ID_VALIDATOR.validate(request.getRegistryPackages().get(0).getHome());
        new HomeCommunityIdValidator(profile.getInteractionId() == XCDR.Interactions.ITI_80).validate(request.getSingleSlotValue("homeCommunityId"));
    }

    @Generated
    public static SubmitObjectsRequestValidator getInstance() {
        return instance;
    }
}

