/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.validate.responses;

import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.openehealth.ipf.commons.core.modules.api.Validator;
import org.openehealth.ipf.commons.ihe.xds.XDS;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLObjectContainer;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLQueryResponse;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLRegistryObject;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.DocumentEntryType;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.ObjectReference;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationMessage;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationProfile;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidatorAssertions;
import org.openehealth.ipf.commons.ihe.xds.core.validate.XDSMetaDataException;
import org.openehealth.ipf.commons.ihe.xds.core.validate.requests.ObjectContainerValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.responses.RegistryResponseValidator;

public class QueryResponseValidator
implements Validator<EbXMLQueryResponse<?>, ValidationProfile> {
    private final RegistryResponseValidator regResponseValidator = RegistryResponseValidator.getInstance();
    private final ObjectContainerValidator objectContainerValidator = ObjectContainerValidator.getInstance();
    private static final QueryResponseValidator instance = new QueryResponseValidator();

    private QueryResponseValidator() {
    }

    public void validate(EbXMLQueryResponse<?> response, ValidationProfile profile) {
        Objects.requireNonNull(response, "response cannot be null");
        this.regResponseValidator.validate(response, profile);
        this.objectContainerValidator.validate(response, profile);
        List<ObjectReference> references = response.getReferences();
        references.forEach(objRef -> ValidatorAssertions.metaDataAssert(objRef.getId() != null, ValidationMessage.MISSING_OBJ_REF, new Object[0]));
        if (profile != XDS.Interactions.ITI_51) {
            this.validatePatientIdsAreIdentical(response);
        }
    }

    private void validatePatientIdsAreIdentical(EbXMLObjectContainer container) throws XDSMetaDataException {
        String patientId = this.checkForMultiplePatientIds(null, "urn:uuid:6b5aea1a-874d-4603-a4bc-96a0a7b38446", container.getRegistryPackages("urn:uuid:a54d6aa5-d40d-43f9-88c5-b4633d873bdd"));
        patientId = this.checkForMultiplePatientIds(patientId, "urn:uuid:58a6f841-87b3-4a3e-92fd-a8ffeff98427", container.getExtrinsicObjects(DocumentEntryType.STABLE_OR_ON_DEMAND));
        this.checkForMultiplePatientIds(patientId, "urn:uuid:f64ffdf0-4b97-4e06-b79f-a52b38ec2f8a", container.getRegistryPackages("urn:uuid:d9d542f3-6cc4-48b6-8870-ea235fbc94c2"));
    }

    private String checkForMultiplePatientIds(String patientId, String id, List<? extends EbXMLRegistryObject> entries) {
        for (EbXMLRegistryObject ebXMLRegistryObject : entries) {
            String patientIdEntry = ebXMLRegistryObject.getExternalIdentifierValue(id);
            patientId = patientId == null ? patientIdEntry : patientId;
            ValidatorAssertions.metaDataAssert(patientId.equals(patientIdEntry), ValidationMessage.RESULT_NOT_SINGLE_PATIENT, new Object[0]);
        }
        return patientId;
    }

    @Generated
    public static QueryResponseValidator getInstance() {
        return instance;
    }
}

