/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.validate.responses;

import java.util.Objects;
import lombok.Generated;
import org.openehealth.ipf.commons.core.modules.api.Validator;
import org.openehealth.ipf.commons.ihe.xds.XCA;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLRegistryResponse;
import org.openehealth.ipf.commons.ihe.xds.core.validate.HomeCommunityIdValidator;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationMessage;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidationProfile;
import org.openehealth.ipf.commons.ihe.xds.core.validate.ValidatorAssertions;

public class RegistryResponseValidator
implements Validator<EbXMLRegistryResponse<?>, ValidationProfile> {
    private final HomeCommunityIdValidator hcValidator = new HomeCommunityIdValidator(true);
    private static final RegistryResponseValidator instance = new RegistryResponseValidator();

    private RegistryResponseValidator() {
    }

    public void validate(EbXMLRegistryResponse<?> response, ValidationProfile profile) {
        Objects.requireNonNull(response, "response cannot be null");
        ValidatorAssertions.metaDataAssert(response.getStatus() != null, ValidationMessage.INVALID_STATUS_IN_RESPONSE, new Object[0]);
        response.getErrors().forEach(registryError -> {
            ValidatorAssertions.metaDataAssert(registryError != null, ValidationMessage.INVALID_ERROR_INFO_IN_RESPONSE, new Object[0]);
            ValidatorAssertions.metaDataAssert(registryError.getErrorCode() != null, ValidationMessage.INVALID_ERROR_CODE_IN_RESPONSE, new Object[0]);
            ValidatorAssertions.metaDataAssert(registryError.getSeverity() != null, ValidationMessage.INVALID_SEVERITY_IN_RESPONSE, new Object[0]);
            if (profile.getInteractionId() == XCA.Interactions.ITI_38 || profile.getInteractionId() == XCA.Interactions.ITI_39) {
                this.hcValidator.validate(registryError.getLocation());
            }
        });
    }

    @Generated
    public static RegistryResponseValidator getInstance() {
        return instance;
    }
}

