/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.tools.analysis.checkstyle;

import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.FileText;
import java.io.File;
import java.util.Set;
import org.apache.ivy.osgi.core.BundleInfo;
import org.apache.ivy.osgi.core.BundleRequirement;
import org.openhab.tools.analysis.checkstyle.api.AbstractStaticCheck;

public class AnnotationDependencyCheck
extends AbstractStaticCheck {
    private static final String DEPENDENCY_NAME = "org.eclipse.jdt.annotation";
    private static final String DEPENDENCY_RESOLUTION = "optional";
    private static final String IMPORT_PACKAGE_HEADER_NAME = "Import-Package";
    private static final String WARNING_MESSAGE_MISSING_DEPENDENCY_RESOLUTION = "Every bundle should have optional Import-Package dependency to org.eclipse.jdt.annotation.";

    public AnnotationDependencyCheck() {
        this.setFileExtensions(new String[]{"MF"});
    }

    protected void processFiltered(File file, FileText fileText) throws CheckstyleException {
        if (this.isEmpty(fileText)) {
            return;
        }
        BundleInfo bundleInfo = this.parseManifestFromFile(fileText);
        Set bundleRequirements = bundleInfo.getRequirements();
        int lineNo = this.findLineNumberSafe(fileText, IMPORT_PACKAGE_HEADER_NAME, 0, "Could not find Import-Package dependency!");
        if (lineNo == 0) {
            return;
        }
        boolean hasOptionalDependencyResolution = false;
        for (BundleRequirement requirement : bundleRequirements) {
            String dependencyName = requirement.getName();
            String dependencyResolution = requirement.getResolution();
            if (!DEPENDENCY_NAME.equals(dependencyName) || !DEPENDENCY_RESOLUTION.equals(dependencyResolution)) continue;
            hasOptionalDependencyResolution = true;
            break;
        }
        if (!hasOptionalDependencyResolution) {
            this.log(lineNo, WARNING_MESSAGE_MISSING_DEPENDENCY_RESOLUTION, new Object[0]);
        }
    }
}

