/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.tools.analysis.checkstyle;

import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;

public class AvoidScheduleAtFixedRateCheck
extends AbstractCheck {
    private static final String WARNING_MESSAGE = "For periodically executed jobs that do not require a fixed rate scheduleWithFixedDelay should be preferred over scheduleAtFixedRate.";
    private static final String METHOD_TO_BE_AVOIDED = "scheduleAtFixedRate";

    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    public int[] getAcceptableTokens() {
        return new int[]{27};
    }

    public int[] getRequiredTokens() {
        return CommonUtil.EMPTY_INT_ARRAY;
    }

    public void visitToken(DetailAST ast) {
        DetailAST methodName;
        DetailAST fullCall = ast.findFirstToken(59);
        if (fullCall != null && METHOD_TO_BE_AVOIDED.equals((methodName = fullCall.getLastChild()).getText())) {
            this.log(methodName.getLineNo(), WARNING_MESSAGE, new Object[0]);
        }
    }
}

