/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.tools.analysis.checkstyle;

import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.FileText;
import java.io.File;
import java.util.Set;
import org.apache.ivy.osgi.core.BundleInfo;
import org.openhab.tools.analysis.checkstyle.api.AbstractStaticCheck;

public class ExportInternalPackageCheck
extends AbstractStaticCheck {
    public ExportInternalPackageCheck() {
        this.setFileExtensions(new String[]{"MF"});
    }

    protected void processFiltered(File file, FileText fileText) throws CheckstyleException {
        if (this.isEmpty(fileText)) {
            this.log(0, "Manifest file is empty!", new Object[]{0});
            return;
        }
        BundleInfo manifest = this.parseManifestFromFile(fileText);
        Set exports = manifest.getExports();
        if (!exports.isEmpty()) {
            int lineNumber = this.findLineNumberSafe(fileText, "Export-Package", 0, "Header line number not found.");
            for (Object export : exports) {
                String packageName = export.toString();
                if (!packageName.contains(".internal")) continue;
                this.log(lineNumber, "Remove internal package export " + packageName, new Object[]{0});
            }
        }
    }
}

