/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.tools.analysis.checkstyle;

import com.puppycrawl.tools.checkstyle.api.CheckstyleException;
import com.puppycrawl.tools.checkstyle.api.FileText;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openhab.tools.analysis.checkstyle.api.AbstractStaticCheck;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class KarafFeatureCheck
extends AbstractStaticCheck {
    private static final String MSG_MISSING_BUNDLE_IN_FEATURE_XML = "Bundle with ID '{0}' must be added in one of {1}";
    private static final String BINDING_ID_PATTERN = "mvn:{0}/{1}/{2}";
    private static final String BINDING_FEATURE_EXPRESSION = "//features/feature/bundle[text()=\"{0}\"]";
    private static final String POM_ARTIFACT_ID_XPATH_EXPRESSION = "//project/artifactId/text()";
    private static final String POM_GROUP_ID_XPATH_EXPRESSION = "//project/groupId/text()";
    private static final String POM_PARENT_GROUP_ID_XPATH_EXPRESSION = "//project/parent/groupId/text()";
    private final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private String featureXmlPath;

    public KarafFeatureCheck() {
        this.setFileExtensions(new String[]{"xml"});
    }

    public void setFeatureXmlPath(String featureXmlPath) {
        this.featureXmlPath = featureXmlPath;
    }

    protected void processFiltered(File file, FileText fileText) throws CheckstyleException {
        if ("pom.xml".equals(file.getName())) {
            String bundleId = this.getBundleId(fileText);
            if (bundleId == null) {
                this.logger.warn((Object)(((Object)((Object)this)).getClass().getSimpleName() + " will be skipped. Could not find Maven group ID (parent group ID) or artifact ID in " + file.getAbsolutePath()));
                return;
            }
            String expression = MessageFormat.format(BINDING_FEATURE_EXPRESSION, bundleId);
            String[] individualPaths = this.featureXmlPath.split(":");
            boolean isFound = false;
            for (int i = 0; i < individualPaths.length; ++i) {
                String singlePath = individualPaths[i];
                Path featurePath = this.resolveRecursively(file.toPath(), Paths.get(singlePath, new String[0]));
                if (featurePath == null) {
                    this.logger.warn((Object)("Could not find file feature file " + singlePath));
                    continue;
                }
                try {
                    FileText featureFileText = new FileText(featurePath.toFile(), StandardCharsets.UTF_8.name());
                    Document featureXML = this.parseDomDocumentFromFile(featureFileText);
                    Node result = this.getFirstNode(featureXML, expression);
                    if (result == null) continue;
                    isFound = true;
                    break;
                }
                catch (IOException e) {
                    this.logger.error((Object)("Could not read " + this.featureXmlPath));
                }
            }
            if (!isFound) {
                this.log(0, MessageFormat.format(MSG_MISSING_BUNDLE_IN_FEATURE_XML, bundleId, this.featureXmlPath), new Object[0]);
            }
        }
    }

    private String getBundleId(FileText fileText) throws CheckstyleException {
        Document featureXML = this.parseDomDocumentFromFile(fileText);
        Node artifactId = this.getFirstNode(featureXML, POM_ARTIFACT_ID_XPATH_EXPRESSION);
        Node groupId = this.getFirstNode(featureXML, POM_GROUP_ID_XPATH_EXPRESSION);
        Node parentGroupId = this.getFirstNode(featureXML, POM_PARENT_GROUP_ID_XPATH_EXPRESSION);
        if (artifactId != null && groupId != null) {
            return MessageFormat.format(BINDING_ID_PATTERN, groupId.getNodeValue(), artifactId.getNodeValue(), "${project.version}");
        }
        if (artifactId != null && parentGroupId != null) {
            return MessageFormat.format(BINDING_ID_PATTERN, parentGroupId.getNodeValue(), artifactId.getNodeValue(), "${project.version}");
        }
        return null;
    }

    private Node getFirstNode(Document document, String xpathExpression) {
        try {
            XPathExpression artifactIdExpression = this.compileXPathExpression(xpathExpression);
            return ((NodeList)artifactIdExpression.evaluate(document, XPathConstants.NODESET)).item(0);
        }
        catch (CheckstyleException | XPathExpressionException e) {
            this.logger.error((Object)("Could not evaluate XPath expression " + xpathExpression), e);
            return null;
        }
    }

    private Path resolveRecursively(Path absolute, Path relativePath) {
        while (absolute.getNameCount() > 0) {
            Path resolved = (absolute = absolute.getParent()).resolve(relativePath);
            if (!Files.exists(resolved, new LinkOption[0])) continue;
            return resolved;
        }
        return null;
    }
}

